/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import io.quarkus.amazon.lambda.http.CognitoPrincipal;
import io.quarkus.amazon.lambda.http.CustomPrincipal;
import io.quarkus.amazon.lambda.http.DefaultLambdaAuthenticationRequest;
import io.quarkus.amazon.lambda.http.IAMPrincipal;
import io.quarkus.amazon.lambda.http.LambdaHttpRecorder;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequest;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequestContext;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;

@ApplicationScoped
public final class DefaultLambdaIdentityProvider
implements IdentityProvider<DefaultLambdaAuthenticationRequest> {
    public Class<DefaultLambdaAuthenticationRequest> getRequestType() {
        return DefaultLambdaAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(DefaultLambdaAuthenticationRequest request, AuthenticationRequestContext context) {
        AwsProxyRequest event = request.getEvent();
        SecurityIdentity identity = DefaultLambdaIdentityProvider.authenticate(event, LambdaHttpRecorder.config.mapCognitoToRoles);
        if (identity == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        return Uni.createFrom().item((Object)identity);
    }

    public static SecurityIdentity authenticate(AwsProxyRequest event, boolean groups) {
        Principal principal = DefaultLambdaIdentityProvider.getPrincipal(event);
        if (principal == null) {
            return null;
        }
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal(principal);
        if (groups && principal instanceof CognitoPrincipal) {
            CognitoPrincipal cognito = (CognitoPrincipal)((Object)principal);
            for (String group : cognito.getGroups()) {
                builder.addRole(group);
            }
        }
        return builder.build();
    }

    public static Principal getPrincipal(AwsProxyRequest request) {
        Map<String, String> systemEnvironment = System.getenv();
        boolean isSamLocal = Boolean.parseBoolean(systemEnvironment.get("AWS_SAM_LOCAL"));
        AwsProxyRequestContext requestContext = request.getRequestContext();
        if (isSamLocal && (requestContext == null || requestContext.getAuthorizer() == null && requestContext.getIdentity() == null)) {
            String forcedUserName = systemEnvironment.get("QUARKUS_AWS_LAMBDA_FORCE_USER_NAME");
            if (forcedUserName != null && !forcedUserName.isEmpty()) {
                return new QuarkusPrincipal(forcedUserName);
            }
        } else if (requestContext != null) {
            if (requestContext.getIdentity() != null && requestContext.getIdentity().getUser() != null) {
                return new IAMPrincipal(requestContext.getIdentity());
            }
            if (requestContext.getAuthorizer() != null) {
                if (requestContext.getAuthorizer().getClaims() != null) {
                    return new CognitoPrincipal(requestContext.getAuthorizer().getClaims());
                }
                if (requestContext.getAuthorizer().getPrincipalId() != null) {
                    return new CustomPrincipal(requestContext.getAuthorizer().getPrincipalId(), requestContext.getAuthorizer().getContextProperties());
                }
            }
        }
        return null;
    }
}

