/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.s3.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@ApplicationScoped
public class S3ClientProducer {
    private final S3Client syncClient;
    private final S3AsyncClient asyncClient;

    S3ClientProducer(Instance<S3ClientBuilder> syncClientBuilderInstance, Instance<S3AsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (S3Client)((S3ClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (S3AsyncClient)((S3AsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @Produces
    @ApplicationScoped
    public S3Client client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The S3Client is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @Produces
    @ApplicationScoped
    public S3AsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The S3AsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

