/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sqs.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@ApplicationScoped
public class SqsClientProducer {
    private volatile SqsClientBuilder syncConfiguredBuilder;
    private volatile SqsAsyncClientBuilder asyncConfiguredBuilder;
    private SqsClient client;
    private SqsAsyncClient asyncClient;

    @Produces
    @ApplicationScoped
    public SqsClient client() {
        this.client = (SqsClient)this.syncConfiguredBuilder.build();
        return this.client;
    }

    @Produces
    @ApplicationScoped
    public SqsAsyncClient asyncClient() {
        this.asyncClient = (SqsAsyncClient)this.asyncConfiguredBuilder.build();
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }

    public void setSyncConfiguredBuilder(SqsClientBuilder syncConfiguredBuilder) {
        this.syncConfiguredBuilder = syncConfiguredBuilder;
    }

    public void setAsyncConfiguredBuilder(SqsAsyncClientBuilder asyncConfiguredBuilder) {
        this.asyncConfiguredBuilder = asyncConfiguredBuilder;
    }
}

