/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.util;

public class PropertyUtils {
    public static Integer getProperty(String propertyName, int defaultValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        Integer result = Integer.getInteger(propertyName);
        try {
            if (result == null) {
                String stringValue = System.getenv(PropertyUtils.transformToEnvVarName(propertyName));
                result = stringValue != null ? Integer.valueOf(Integer.parseInt(stringValue)) : Integer.valueOf(defaultValue);
            }
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static String getProperty(String propertyName, String defaultValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        String result = System.getProperty(propertyName);
        try {
            if (result == null) {
                String stringValue = System.getenv(PropertyUtils.transformToEnvVarName(propertyName));
                result = stringValue != null ? stringValue : defaultValue;
            }
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static boolean getProperty(String propertyName, boolean defaultValue) {
        boolean result;
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        String systemValue = System.getProperty(propertyName);
        try {
            String envValue;
            result = systemValue == null ? ((envValue = System.getenv(PropertyUtils.transformToEnvVarName(propertyName))) != null ? Boolean.parseBoolean(envValue) : defaultValue) : Boolean.parseBoolean(systemValue);
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    private static String transformToEnvVarName(String propertyName) {
        return propertyName.toUpperCase().replace('.', '_');
    }
}

