/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.apicurio.registry.avro;

import io.quarkus.apicurio.registry.avro.ApicurioRegistryDevServicesBuildTimeConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.Objects;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public class DevServicesApicurioRegistryProcessor {
    private static final Logger log = Logger.getLogger(DevServicesApicurioRegistryProcessor.class);
    private static final String REGISTRY_URL_CONFIG = "mp.messaging.connector.smallrye-kafka.apicurio.registry.url";
    static volatile AutoCloseable closeable;
    static volatile ApicurioRegistryDevServiceCfg cfg;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class})
    public void startApicurioRegistryDevService(LaunchModeBuildItem launchMode, ApicurioRegistryDevServicesBuildTimeConfig apicurioRegistryDevServices, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<DevServicesNativeConfigResultBuildItem> devServicesConfiguration) {
        ApicurioRegistry apicurioRegistry;
        ApicurioRegistryDevServiceCfg configuration = this.getConfiguration(apicurioRegistryDevServices);
        if (closeable != null) {
            boolean restartRequired;
            boolean bl = restartRequired = launchMode.getLaunchMode() == LaunchMode.TEST;
            if (!restartRequired) {
                boolean bl2 = restartRequired = !configuration.equals(cfg);
            }
            if (!restartRequired) {
                return;
            }
            this.shutdownApicurioRegistry();
            cfg = null;
        }
        if ((apicurioRegistry = this.startApicurioRegistry(configuration)) == null) {
            return;
        }
        cfg = configuration;
        closeable = apicurioRegistry.getCloseable();
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(REGISTRY_URL_CONFIG, apicurioRegistry.getUrl() + "/apis/registry/v2"));
        devServicesConfiguration.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(REGISTRY_URL_CONFIG, apicurioRegistry.getUrl() + "/apis/registry/v2"));
        log.infof("Dev Services for Apicurio Registry started. The registry is available at %s", (Object)apicurioRegistry.getUrl());
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (closeable != null) {
                        DevServicesApicurioRegistryProcessor.this.shutdownApicurioRegistry();
                    }
                    first = true;
                    closeable = null;
                    cfg = null;
                }
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
            final Thread closeHookThread = new Thread(closeTask, "Apicurio Registry container shutdown thread");
            Runtime.getRuntime().addShutdownHook(closeHookThread);
            ((QuarkusClassLoader)cl.parent()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().removeShutdownHook(closeHookThread);
                }
            });
        }
    }

    private void shutdownApicurioRegistry() {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop Apicurio Registry", e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private ApicurioRegistry startApicurioRegistry(ApicurioRegistryDevServiceCfg config) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)REGISTRY_URL_CONFIG)) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, mp.messaging.connector.smallrye-kafka.apicurio.registry.url is configured.");
            return null;
        }
        if (!this.hasKafkaChannelWithoutApicurioRegistry()) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, all the channels have a registry URL configured.");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            log.warn((Object)"Docker isn't working, please run Apicurio Registry yourself.");
            return null;
        }
        ApicurioRegistryContainer container = new ApicurioRegistryContainer(DockerImageName.parse((String)config.imageName), config.fixedExposedPort);
        container.start();
        return new ApicurioRegistry(container.getUrl(), (AutoCloseable)((Object)container));
    }

    private boolean hasKafkaChannelWithoutApicurioRegistry() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            boolean isKafka = isConnector && "smallrye-kafka".equals(config.getOptionalValue(name, String.class).orElse("ignored"));
            boolean isConfigured = false;
            if ((isIncoming || isOutgoing) && isKafka) {
                isConfigured = ConfigUtils.isPropertyPresent((String)name.replace(".connector", ".apicurio.registry.url"));
            }
            if (isConfigured) continue;
            return true;
        }
        return false;
    }

    private ApicurioRegistryDevServiceCfg getConfiguration(ApicurioRegistryDevServicesBuildTimeConfig cfg) {
        return new ApicurioRegistryDevServiceCfg(cfg.enabled.orElse(true), cfg.imageName, cfg.port.orElse(0));
    }

    static {
        first = true;
    }

    private static final class ApicurioRegistryContainer
    extends GenericContainer<ApicurioRegistryContainer> {
        private static final int APICURIO_REGISTRY_PORT = 8080;
        private final int port;

        private ApicurioRegistryContainer(DockerImageName dockerImageName, int fixedExposedPort) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            this.withNetwork(Network.SHARED);
            this.withExposedPorts(new Integer[]{8080});
            this.withEnv("QUARKUS_PROFILE", "prod");
            if (!dockerImageName.getRepository().equals("apicurio/apicurio-registry-mem")) {
                throw new IllegalArgumentException("Only apicurio/apicurio-registry-mem images are supported");
            }
        }

        protected void configure() {
            super.configure();
            if (this.port > 0) {
                this.addFixedExposedPort(this.port, 8080);
            }
        }

        public String getUrl() {
            return String.format("http://%s:%s", this.getContainerIpAddress(), this.getMappedPort(8080));
        }
    }

    private static final class ApicurioRegistryDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;

        public ApicurioRegistryDevServiceCfg(boolean devServicesEnabled, String imageName, Integer fixedExposedPort) {
            this.devServicesEnabled = devServicesEnabled;
            this.imageName = imageName;
            this.fixedExposedPort = fixedExposedPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApicurioRegistryDevServiceCfg that = (ApicurioRegistryDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    private static class ApicurioRegistry {
        private final String url;
        private final AutoCloseable closeable;

        public ApicurioRegistry(String url, AutoCloseable closeable) {
            this.url = url;
            this.closeable = closeable;
        }

        public String getUrl() {
            return this.url;
        }

        public AutoCloseable getCloseable() {
            return this.closeable;
        }
    }
}

