/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.apicurio.registry.avro;

import io.quarkus.apicurio.registry.avro.ApicurioRegistryDevServicesBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class DevServicesApicurioRegistryProcessor {
    private static final Logger log = Logger.getLogger(DevServicesApicurioRegistryProcessor.class);
    private static final int APICURIO_REGISTRY_PORT = 8080;
    private static final String REGISTRY_URL_CONFIG = "mp.messaging.connector.smallrye-kafka.apicurio.registry.url";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-apicurio-registry";
    private static final ContainerLocator apicurioRegistryContainerLocator = new ContainerLocator("quarkus-dev-service-apicurio-registry", 8080);
    static volatile AutoCloseable closeable;
    static volatile ApicurioRegistryDevServiceCfg cfg;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void startApicurioRegistryDevService(LaunchModeBuildItem launchMode, ApicurioRegistryDevServicesBuildTimeConfig apicurioRegistryDevServices, Optional<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, BuildProducer<DevServicesConfigResultBuildItem> devServicesConfiguration, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ApicurioRegistry apicurioRegistry;
        ApicurioRegistryDevServiceCfg configuration = this.getConfiguration(apicurioRegistryDevServices);
        if (closeable != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !configuration.equals(cfg);
            if (!restartRequired) {
                return;
            }
            this.shutdownApicurioRegistry();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Apicurio Registry Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            apicurioRegistry = this.startApicurioRegistry(configuration, launchMode, devServicesSharedNetworkBuildItem.isPresent(), devServicesConfig.timeout);
            if (apicurioRegistry == null) {
                compressor.close();
                return;
            }
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        cfg = configuration;
        closeable = apicurioRegistry.getCloseable();
        devServicesConfiguration.produce((BuildItem)new DevServicesConfigResultBuildItem(REGISTRY_URL_CONFIG, apicurioRegistry.getUrl() + "/apis/registry/v2"));
        if (apicurioRegistry.isOwner()) {
            log.infof("Dev Services for Apicurio Registry started. The registry is available at %s", (Object)apicurioRegistry.getUrl());
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (closeable != null) {
                        DevServicesApicurioRegistryProcessor.this.shutdownApicurioRegistry();
                    }
                    first = true;
                    closeable = null;
                    cfg = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
    }

    private void shutdownApicurioRegistry() {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop Apicurio Registry", e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private ApicurioRegistry startApicurioRegistry(ApicurioRegistryDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)REGISTRY_URL_CONFIG)) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, mp.messaging.connector.smallrye-kafka.apicurio.registry.url is configured.");
            return null;
        }
        if (!this.hasKafkaChannelWithoutApicurioRegistry()) {
            log.debug((Object)"Not starting dev services for Apicurio Registry, all the channels have a registry URL configured.");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            log.warn((Object)"Docker isn't working, please run Apicurio Registry yourself.");
            return null;
        }
        return apicurioRegistryContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> new ApicurioRegistry(containerAddress.getUrl(), null)).orElseGet(() -> {
            ApicurioRegistryContainer container = new ApicurioRegistryContainer(DockerImageName.parse((String)config.imageName), config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((ApicurioRegistryContainer)container).withStartupTimeout(arg_0));
            container.start();
            return new ApicurioRegistry(container.getUrl(), (AutoCloseable)((Object)container));
        });
    }

    private boolean hasKafkaChannelWithoutApicurioRegistry() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            boolean isKafka = isConnector && "smallrye-kafka".equals(config.getOptionalValue(name, String.class).orElse("ignored"));
            boolean isConfigured = false;
            if ((isIncoming || isOutgoing) && isKafka) {
                isConfigured = ConfigUtils.isPropertyPresent((String)name.replace(".connector", ".apicurio.registry.url"));
            }
            if (isConfigured) continue;
            return true;
        }
        return false;
    }

    private ApicurioRegistryDevServiceCfg getConfiguration(ApicurioRegistryDevServicesBuildTimeConfig cfg) {
        return new ApicurioRegistryDevServiceCfg(cfg);
    }

    static {
        first = true;
    }

    private static final class ApicurioRegistryContainer
    extends GenericContainer<ApicurioRegistryContainer> {
        private final int port;
        private final boolean useSharedNetwork;
        private String hostName = null;

        private ApicurioRegistryContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.withNetwork(Network.SHARED);
            if (useSharedNetwork) {
                this.hostName = "kafka-" + Base58.randomString((int)5);
                this.setNetworkAliases(Collections.singletonList(this.hostName));
            } else {
                this.withExposedPorts(new Integer[]{8080});
            }
            if (serviceName != null) {
                this.withLabel(DevServicesApicurioRegistryProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.withEnv("QUARKUS_PROFILE", "prod");
            if (!dockerImageName.getRepository().equals("apicurio/apicurio-registry-mem")) {
                throw new IllegalArgumentException("Only apicurio/apicurio-registry-mem images are supported");
            }
        }

        protected void configure() {
            super.configure();
            if (this.port > 0 && !this.useSharedNetwork) {
                this.addFixedExposedPort(this.port, 8080);
            }
        }

        public String getUrl() {
            return String.format("http://%s:%s", this.getHostToUse(), this.getPortToUse());
        }

        private String getHostToUse() {
            return this.useSharedNetwork ? this.hostName : this.getHost();
        }

        private int getPortToUse() {
            return this.useSharedNetwork ? 8080 : this.getMappedPort(8080);
        }
    }

    private static final class ApicurioRegistryDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;

        public ApicurioRegistryDevServiceCfg(ApicurioRegistryDevServicesBuildTimeConfig config) {
            this.devServicesEnabled = config.enabled.orElse(true);
            this.imageName = config.imageName;
            this.fixedExposedPort = config.port.orElse(0);
            this.shared = config.shared;
            this.serviceName = config.serviceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApicurioRegistryDevServiceCfg that = (ApicurioRegistryDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && this.shared == that.shared && Objects.equals(this.serviceName, that.serviceName);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.shared, this.serviceName);
        }
    }

    private static class ApicurioRegistry {
        private final String url;
        private final AutoCloseable closeable;

        public ApicurioRegistry(String url, AutoCloseable closeable) {
            this.url = url;
            this.closeable = closeable;
        }

        public String getUrl() {
            return this.url;
        }

        public AutoCloseable getCloseable() {
            return this.closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }
    }
}

