/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;

public final class AdditionalBeanBuildItem
extends MultiBuildItem {
    private final List<String> beanClasses;
    private final boolean removable;
    private final DotName defaultScope;

    public static Builder builder() {
        return new Builder();
    }

    public static AdditionalBeanBuildItem unremovableOf(Class<?> beanClass) {
        return new AdditionalBeanBuildItem(Collections.singletonList(beanClass.getName()), false, null);
    }

    public AdditionalBeanBuildItem(String ... beanClasses) {
        this(Arrays.asList(beanClasses), true, null);
    }

    public AdditionalBeanBuildItem(Class<?> ... beanClasses) {
        this(Arrays.stream(beanClasses).map(Class::getName).collect(Collectors.toList()), true, null);
    }

    AdditionalBeanBuildItem(List<String> beanClasses, boolean removable, DotName defaultScope) {
        this.beanClasses = beanClasses;
        this.removable = removable;
        this.defaultScope = defaultScope;
    }

    public List<String> getBeanClasses() {
        return Collections.unmodifiableList(this.beanClasses);
    }

    public boolean contains(String beanClass) {
        return this.beanClasses.contains(beanClass);
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public DotName getDefaultScope() {
        return this.defaultScope;
    }

    public static class Builder {
        private final List<String> beanClasses = new ArrayList<String>();
        private boolean removable = true;
        private DotName defaultScope;

        public Builder addBeanClasses(Class<?> ... beanClasses) {
            Arrays.stream(beanClasses).map(Class::getName).forEach(this.beanClasses::add);
            return this;
        }

        public Builder addBeanClasses(String ... beanClasses) {
            Collections.addAll(this.beanClasses, beanClasses);
            return this;
        }

        public Builder addBeanClasses(Collection<String> beanClasses) {
            this.beanClasses.addAll(beanClasses);
            return this;
        }

        public Builder addBeanClass(String beanClass) {
            this.beanClasses.add(beanClass);
            return this;
        }

        public Builder addBeanClass(Class<?> beanClass) {
            this.beanClasses.add(beanClass.getName());
            return this;
        }

        public Builder setRemovable() {
            this.removable = true;
            return this;
        }

        public Builder setUnremovable() {
            this.removable = false;
            return this;
        }

        public Builder setDefaultScope(DotName defaultScope) {
            this.defaultScope = defaultScope;
            return this;
        }

        public AdditionalBeanBuildItem build() {
            return new AdditionalBeanBuildItem(new ArrayList<String>(this.beanClasses), this.removable, this.defaultScope);
        }
    }
}

