/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AdditionalStereotypeBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.deployment.ContextRegistrarBuildItem;
import io.quarkus.arc.deployment.ResourceAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.runtime.AdditionalBean;
import io.quarkus.arc.runtime.ArcDeploymentTemplate;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.LifecycleEventRunner;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveMethodBuildItem;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ArcAnnotationProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.arc.deployment.processor");
    static final DotName ADDITIONAL_BEAN = DotName.createSimple((String)AdditionalBean.class.getName());
    @Inject
    BeanArchiveIndexBuildItem beanArchiveIndex;
    @Inject
    BuildProducer<GeneratedClassBuildItem> generatedClass;
    @Inject
    BuildProducer<GeneratedResourceBuildItem> generatedResource;
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    List<AdditionalBeanBuildItem> additionalBeans;
    @Inject
    BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods;
    @Inject
    BuildProducer<ReflectiveFieldBuildItem> reflectiveFields;
    @Inject
    List<BeanRegistrarBuildItem> beanRegistrars;
    @Inject
    List<ContextRegistrarBuildItem> contextRegistrars;
    @Inject
    List<BeanDeploymentValidatorBuildItem> beanDeploymentValidators;
    @Inject
    List<ResourceAnnotationBuildItem> resourceAnnotations;
    @Inject
    List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations;
    @Inject
    List<UnremovableBeanBuildItem> removalExclusions;
    @Inject
    Optional<TestClassPredicateBuildItem> testClassPredicate;
    ArcConfig arc;

    @BuildStep(providesCapabilities={"io.quarkus.cdi"}, applicationArchiveMarkers={"META-INF/beans.xml", "META-INF/services/javax.enterprise.inject.spi.Extension"})
    @Record(value=ExecutionTime.STATIC_INIT)
    public BeanContainerBuildItem build(ArcDeploymentTemplate arcTemplate, List<BeanContainerListenerBuildItem> beanContainerListenerBuildItems, final ApplicationArchivesBuildItem applicationArchivesBuildItem, List<AnnotationsTransformerBuildItem> annotationTransformers, ShutdownContextBuildItem shutdown, List<AdditionalStereotypeBuildItem> additionalStereotypeBuildItems, BuildProducer<FeatureBuildItem> feature) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("cdi"));
        final List<String> additionalBeans = this.beanArchiveIndex.getAdditionalBeans();
        final Set<DotName> generatedClassNames = this.beanArchiveIndex.getGeneratedClassNames();
        IndexView index = this.beanArchiveIndex.getIndex();
        BeanProcessor.Builder builder = BeanProcessor.builder();
        builder.setApplicationClassPredicate((Predicate)new Predicate<DotName>(){

            @Override
            public boolean test(DotName dotName) {
                if (applicationArchivesBuildItem.getRootArchive().getIndex().getClassByName(dotName) != null) {
                    return true;
                }
                return generatedClassNames.contains(dotName);
            }
        });
        builder.addAnnotationTransformer(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return AnnotationTarget.Kind.CLASS == kind;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo beanClass = transformationContext.getTarget().asClass();
                String beanClassName = beanClass.name().toString();
                if (additionalBeans.contains(beanClassName)) {
                    DotName defaultScope = ArcAnnotationProcessor.this.additionalBeans.stream().filter(ab -> ab.contains(beanClassName)).findFirst().map(AdditionalBeanBuildItem::getDefaultScope).orElse(null);
                    if (defaultScope == null && !beanClass.annotations().containsKey(ADDITIONAL_BEAN)) {
                        transformationContext.transform().add(ADDITIONAL_BEAN, new AnnotationValue[0]).done();
                    } else {
                        transformationContext.transform().add(defaultScope, new AnnotationValue[0]).done();
                    }
                }
            }
        });
        builder.setIndex(index);
        List beanDefiningAnnotations = this.additionalBeanDefiningAnnotations.stream().map(s -> new BeanDefiningAnnotation(s.getName(), s.getDefaultScope())).collect(Collectors.toList());
        beanDefiningAnnotations.add(new BeanDefiningAnnotation(ADDITIONAL_BEAN, null));
        builder.setAdditionalBeanDefiningAnnotations(beanDefiningAnnotations);
        HashMap<DotName, Collection<AnnotationInstance>> additionalStereotypes = new HashMap<DotName, Collection<AnnotationInstance>>();
        for (AdditionalStereotypeBuildItem additionalStereotypeBuildItem : additionalStereotypeBuildItems) {
            additionalStereotypes.putAll(additionalStereotypeBuildItem.getStereotypes());
        }
        builder.setAdditionalStereotypes(additionalStereotypes);
        builder.setSharedAnnotationLiterals(true);
        builder.addResourceAnnotations((Collection)this.resourceAnnotations.stream().map(ResourceAnnotationBuildItem::getName).collect(Collectors.toList()));
        builder.setReflectionRegistration(new ReflectionRegistration(){

            public void registerMethod(MethodInfo methodInfo) {
                ArcAnnotationProcessor.this.reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(methodInfo));
            }

            public void registerField(FieldInfo fieldInfo) {
                ArcAnnotationProcessor.this.reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(fieldInfo));
            }
        });
        for (AnnotationsTransformerBuildItem annotationsTransformerBuildItem : annotationTransformers) {
            builder.addAnnotationTransformer(annotationsTransformerBuildItem.getAnnotationsTransformer());
        }
        builder.setOutput(new ResourceOutput(){

            public void writeResource(ResourceOutput.Resource resource) throws IOException {
                switch (resource.getType()) {
                    case JAVA_CLASS: {
                        log.debugf("Add %s class: %s", (Object)(resource.isApplicationClass() ? "APP" : "FWK"), (Object)resource.getFullyQualifiedName());
                        ArcAnnotationProcessor.this.generatedClass.produce((BuildItem)new GeneratedClassBuildItem(resource.isApplicationClass(), resource.getName(), resource.getData()));
                        break;
                    }
                    case SERVICE_PROVIDER: {
                        ArcAnnotationProcessor.this.generatedResource.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/services/" + resource.getName(), resource.getData()));
                    }
                }
            }
        });
        for (BeanRegistrarBuildItem beanRegistrarBuildItem : this.beanRegistrars) {
            builder.addBeanRegistrar(beanRegistrarBuildItem.getBeanRegistrar());
        }
        for (ContextRegistrarBuildItem contextRegistrarBuildItem : this.contextRegistrars) {
            builder.addContextRegistrar(contextRegistrarBuildItem.getContextRegistrar());
        }
        for (BeanDeploymentValidatorBuildItem beanDeploymentValidatorBuildItem : this.beanDeploymentValidators) {
            builder.addBeanDeploymentValidator(beanDeploymentValidatorBuildItem.getBeanDeploymentValidator());
        }
        builder.setRemoveUnusedBeans(this.arc.removeUnusedBeans);
        builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(LifecycleEventRunner.class.getName()));
        for (AdditionalBeanBuildItem additionalBeanBuildItem : this.additionalBeans) {
            if (additionalBeanBuildItem.isRemovable()) continue;
            for (String beanClass : additionalBeanBuildItem.getBeanClasses()) {
                builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(beanClass));
            }
        }
        for (BeanDefiningAnnotationBuildItem beanDefiningAnnotationBuildItem : this.additionalBeanDefiningAnnotations) {
            if (beanDefiningAnnotationBuildItem.isRemovable()) continue;
            builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(beanDefiningAnnotationBuildItem.getName()));
        }
        for (UnremovableBeanBuildItem unremovableBeanBuildItem : this.removalExclusions) {
            builder.addRemovalExclusion(unremovableBeanBuildItem.getPredicate());
        }
        if (this.testClassPredicate.isPresent()) {
            builder.addRemovalExclusion((Predicate)new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo bean) {
                    return ArcAnnotationProcessor.this.testClassPredicate.get().getPredicate().test(bean.getBeanClass().toString());
                }
            });
        }
        BeanProcessor beanProcessor = builder.build();
        BeanDeployment beanDeployment = beanProcessor.process();
        ArcContainer container = arcTemplate.getContainer((ShutdownContext)shutdown);
        BeanContainer beanContainer = arcTemplate.initBeanContainer(container, beanContainerListenerBuildItems.stream().map(BeanContainerListenerBuildItem::getBeanContainerListener).collect(Collectors.toList()), (Collection)beanDeployment.getRemovedBeans().stream().flatMap(b -> b.getTypes().stream()).map(t -> t.name().toString()).collect(Collectors.toSet()));
        return new BeanContainerBuildItem(beanContainer);
    }
}

