/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.CurrentInjectionPointProvider;
import io.quarkus.deployment.test.TestResourceProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.HashSet;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ArcTestResourceProvider
implements TestResourceProvider {
    public void inject(Object test) {
        BeanManager beanManager = Arc.container().beanManager();
        for (Class<?> c = test.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class) && !field.isAnnotationPresent(ConfigProperty.class)) continue;
                try {
                    HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                    HashSet<Annotation> annotations = new HashSet<Annotation>();
                    for (Annotation a : field.getAnnotations()) {
                        annotations.add(a);
                        if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                        qualifiers.add(a);
                    }
                    Object instance = beanManager.getInjectableReference((InjectionPoint)new CurrentInjectionPointProvider.InjectionPointImpl(field.getGenericType(), field.getGenericType(), qualifiers, null, annotations, (Member)field, -1), beanManager.createCreationalContext(null));
                    field.setAccessible(true);
                    try {
                        field.set(test, instance);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to inject field " + field, t);
                }
            }
        }
    }
}

