/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import javax.enterprise.context.NormalScope;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class NoArgsConstructorProcessor {
    private static final Logger LOGGER = Logger.getLogger(NoArgsConstructorProcessor.class);
    private static final int ANNOTATION = 8192;
    @Inject
    BeanArchiveIndexBuildItem beanArchiveIndex;
    @Inject
    CombinedIndexBuildItem combinedIndex;
    @Inject
    BuildProducer<BytecodeTransformerBuildItem> transformers;
    @Inject
    BuildProducer<BeanDeploymentValidatorBuildItem> validators;

    @BuildStep
    public void addMissingConstructors() throws Exception {
        HashSet<ClassInfo> targetClasses = new HashSet<ClassInfo>();
        Set<DotName> normalScopes = this.initNormalScopes();
        for (DotName normalScope : normalScopes) {
            this.collectTargetClasses(targetClasses, normalScope);
        }
        Iterator iterator = targetClasses.iterator();
        while (iterator.hasNext()) {
            ClassInfo targetClass = (ClassInfo)iterator.next();
            if (!targetClass.hasNoArgsConstructor()) continue;
            iterator.remove();
        }
        if (targetClasses.isEmpty()) {
            return;
        }
        final HashSet<DotName> transformedClasses = new HashSet<DotName>();
        for (ClassInfo targetClass : targetClasses) {
            ClassInfo superClass;
            final String superClassName = targetClass.superName() == null ? "java/lang/Object" : ((superClass = this.combinedIndex.getIndex().getClassByName(targetClass.superName())) != null && superClass.hasNoArgsConstructor() ? superClass.name().toString().replace('.', '/') : null);
            if (superClassName == null) continue;
            transformedClasses.add(targetClass.name());
            LOGGER.debugf("Adding no-args constructor to %s", (Object)targetClass);
            this.transformers.produce((BuildItem)new BytecodeTransformerBuildItem(targetClass.name().toString(), (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                    ClassVisitor cv = new ClassVisitor(393216, classVisitor){

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            super.visit(version, access, name, signature, superName, interfaces);
                            MethodVisitor mv = this.visitMethod(1, "<init>", "()V", null, null);
                            mv.visitCode();
                            mv.visitVarInsn(25, 0);
                            mv.visitMethodInsn(183, superClassName, "<init>", "()V", false);
                            mv.visitInsn(177);
                            mv.visitMaxs(1, 1);
                            mv.visitEnd();
                        }
                    };
                    return cv;
                }
            }));
        }
        if (!transformedClasses.isEmpty()) {
            this.validators.produce((BuildItem)new BeanDeploymentValidatorBuildItem(new BeanDeploymentValidator(){

                public boolean skipValidation(InjectionTargetInfo target, BeanDeploymentValidator.ValidationRule rule) {
                    return BeanDeploymentValidator.ValidationRule.NO_ARGS_CONSTRUCTOR.equals((Object)rule) && target.kind() == InjectionTargetInfo.TargetKind.BEAN && transformedClasses.contains(target.asBean().getBeanClass());
                }
            }));
        }
    }

    private Set<DotName> initNormalScopes() {
        HashSet<DotName> normalScopes = new HashSet<DotName>();
        normalScopes.add(BuiltinScope.APPLICATION.getName());
        normalScopes.add(BuiltinScope.REQUEST.getName());
        this.combinedIndex.getIndex().getAnnotations(DotName.createSimple((String)NormalScope.class.getName())).stream().filter(NoArgsConstructorProcessor::isTargetAnnotation).map(AnnotationInstance::name).forEach(normalScopes::add);
        return normalScopes;
    }

    private void collectTargetClasses(Set<ClassInfo> targetClasses, DotName normalScope) {
        for (AnnotationInstance annotationInstance : this.beanArchiveIndex.getIndex().getAnnotations(normalScope)) {
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            targetClasses.add(annotationInstance.target().asClass());
        }
    }

    private static boolean isTargetAnnotation(AnnotationInstance annotationInstance) {
        return annotationInstance.target().kind() == AnnotationTarget.Kind.CLASS && (annotationInstance.target().asClass().flags() & 0x2000) != 0;
    }
}

