/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.runtime.ConfigBeanCreator;
import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.arc.runtime.QuarkusConfigProducer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ConfigBuildStep {
    private static final DotName CONFIG_PROPERTY_NAME = DotName.createSimple((String)ConfigProperty.class.getName());
    private static final DotName SET_NAME = DotName.createSimple((String)Set.class.getName());
    private static final DotName LIST_NAME = DotName.createSimple((String)List.class.getName());

    @BuildStep
    AdditionalBeanBuildItem bean() {
        return new AdditionalBeanBuildItem(QuarkusConfigProducer.class);
    }

    @BuildStep
    BeanRegistrarBuildItem analyzeConfigPropertyInjectionPoints(final BuildProducer<ConfigPropertyBuildItem> configProperties, final BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        return new BeanRegistrarBuildItem(new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext context) {
                HashSet<Type> customBeanTypes = new HashSet<Type>();
                for (InjectionPointInfo injectionPoint : (List)context.get(BuildExtension.Key.INJECTION_POINTS)) {
                    String propertyName;
                    AnnotationInstance configProperty;
                    if (injectionPoint.hasDefaultedQualifier() || (configProperty = injectionPoint.getRequiredQualifier(CONFIG_PROPERTY_NAME)) == null) continue;
                    AnnotationValue nameValue = configProperty.value("name");
                    AnnotationValue defaultValue = configProperty.value("defaultValue");
                    if (nameValue != null) {
                        propertyName = nameValue.asString();
                    } else if (injectionPoint.isField()) {
                        FieldInfo field = injectionPoint.getTarget().asField();
                        propertyName = ConfigBuildStep.this.getPropertyName(field.name(), field.declaringClass());
                    } else if (injectionPoint.isParam()) {
                        MethodInfo method = injectionPoint.getTarget().asMethod();
                        propertyName = ConfigBuildStep.this.getPropertyName(method.parameterName(injectionPoint.getPosition()), method.declaringClass());
                    } else {
                        throw new IllegalStateException("Unsupported injection point target: " + injectionPoint);
                    }
                    Type requiredType = injectionPoint.getRequiredType();
                    if (!ConfigBuildStep.this.isHandledByProducers(requiredType)) {
                        customBeanTypes.add(requiredType);
                    }
                    if (DotNames.OPTIONAL.equals((Object)requiredType.name()) || defaultValue != null && !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue.asString())) continue;
                    String propertyType = requiredType.name().toString();
                    if (requiredType.kind() != Type.Kind.ARRAY && requiredType.kind() != Type.Kind.PRIMITIVE) {
                        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{propertyType}));
                    }
                    configProperties.produce((BuildItem)new ConfigPropertyBuildItem(propertyName, propertyType));
                }
                for (Type type : customBeanTypes) {
                    if (type.kind() != Type.Kind.ARRAY) {
                        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.name().toString()}));
                    }
                    context.configure(type.kind() == Type.Kind.ARRAY ? DotName.createSimple((String)ConfigBeanCreator.class.getName()) : type.name()).creator(ConfigBeanCreator.class).providerType(type).types(new Type[]{type}).qualifiers(new AnnotationInstance[]{AnnotationInstance.create((DotName)CONFIG_PROPERTY_NAME, null, Collections.emptyList())}).param("requiredType", type.name().toString()).done();
                }
            }
        });
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectConfigProperty() {
        return new AutoInjectAnnotationBuildItem(CONFIG_PROPERTY_NAME);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateConfigProperties(ConfigRecorder recorder, List<ConfigPropertyBuildItem> configProperties, BeanContainerBuildItem beanContainer) {
        Map propNamesToClasses = configProperties.stream().collect(Collectors.groupingBy(ConfigPropertyBuildItem::getPropertyName, Collectors.mapping(ConfigPropertyBuildItem::getPropertyType, Collectors.toSet())));
        recorder.validateConfigProperties(propNamesToClasses);
    }

    private String getPropertyName(String name, ClassInfo declaringClass) {
        StringBuilder builder = new StringBuilder();
        if (declaringClass.enclosingClass() == null) {
            builder.append(declaringClass.name());
        } else {
            builder.append(declaringClass.enclosingClass()).append(".").append(declaringClass.simpleName());
        }
        return builder.append(".").append(name).toString();
    }

    private boolean isHandledByProducers(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE) {
            switch (type.asPrimitiveType().primitive()) {
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case LONG: 
                case INT: {
                    return true;
                }
            }
            return false;
        }
        return DotNames.STRING.equals((Object)type.name()) || DotNames.OPTIONAL.equals((Object)type.name()) || SET_NAME.equals((Object)type.name()) || LIST_NAME.equals((Object)type.name()) || DotNames.LONG.equals((Object)type.name()) || DotNames.FLOAT.equals((Object)type.name()) || DotNames.INTEGER.equals((Object)type.name()) || DotNames.BOOLEAN.equals((Object)type.name()) || DotNames.DOUBLE.equals((Object)type.name());
    }
}

