/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class AnnotatedUnremovableClassesProcessor {
    private static final DotName UNREMOVABLE = DotName.createSimple((String)Unremovable.class.getName());

    @BuildStep
    public void findAnnotatedClasses(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<UnremovableBeanBuildItem> producer) {
        HashSet<AnnotationTarget> unremovableBeanTargets = new HashSet<AnnotationTarget>();
        Collection unremovableAnnotations = beanArchiveIndexBuildItem.getIndex().getAnnotations(UNREMOVABLE);
        for (AnnotationInstance annotationInstance : unremovableAnnotations) {
            unremovableBeanTargets.add(annotationInstance.target());
        }
        if (!unremovableBeanTargets.isEmpty()) {
            producer.produce((BuildItem)new UnremovableBeanBuildItem(b -> {
                if (b.getTarget().isPresent()) {
                    return unremovableBeanTargets.contains(b.getTarget().get());
                }
                return false;
            }));
        }
    }
}

