/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.RuntimeBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.jboss.jandex.AnnotationTarget;

public class RuntimeBeanProcessor {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(List<RuntimeBeanBuildItem> beans, final BuildProducer<GeneratedBeanBuildItem> generatedBean, ArcRecorder recorder, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        String beanName = "io.quarkus.arc.runtimebean.RuntimeBeanProducers";
        ClassCreator classCreator = new ClassCreator(new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedBean.produce((BuildItem)new GeneratedBeanBuildItem(name, data));
            }
        }, beanName, null, Object.class.getName(), new String[0]);
        classCreator.addAnnotation(ApplicationScoped.class);
        HashMap<String, Supplier<Object>> map = new HashMap<String, Supplier<Object>>();
        for (RuntimeBeanBuildItem bean : beans) {
            final String name = bean.type.replace(".", "_") + "_" + HashUtil.sha1((String)bean.qualifiers.toString());
            if (bean.runtimeValue != null) {
                map.put(name, recorder.createSupplier(bean.runtimeValue));
            } else {
                map.put(name, bean.supplier);
            }
            MethodCreator producer = classCreator.getMethodCreator("produce_" + name, bean.type, new String[0]);
            producer.addAnnotation(Produces.class);
            producer.addAnnotation(bean.scope);
            for (Map.Entry qualifierEntry : bean.qualifiers.entrySet()) {
                AnnotationCreator builder = producer.addAnnotation((String)qualifierEntry.getKey());
                for (Map.Entry valueEntry : ((NavigableMap)qualifierEntry.getValue()).entrySet()) {
                    builder.addValue((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
            if (!bean.removable) {
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

                    @Override
                    public boolean test(BeanInfo bean) {
                        return bean.isProducerMethod() && ((AnnotationTarget)bean.getTarget().get()).asMethod().name().equals(name);
                    }
                }));
            }
            ResultHandle staticMap = producer.readStaticField(FieldDescriptor.of(ArcRecorder.class, (String)"supplierMap", Map.class));
            ResultHandle supplier = producer.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), staticMap, new ResultHandle[]{producer.load(name)});
            ResultHandle result = producer.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), supplier, new ResultHandle[0]);
            producer.returnValue(result);
        }
        classCreator.close();
        recorder.initSupplierBeans(map);
    }
}

