/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesUtil;
import io.quarkus.arc.deployment.configproperties.ConfigPropertyBuildItemCandidate;
import io.quarkus.arc.deployment.configproperties.ConfigPropertyBuildItemCandidateUtil;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.StartupEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class ClassConfigPropertiesUtil {
    private static final String VALIDATOR_CLASS = "javax.validation.Validator";
    private static final String HIBERNATE_VALIDATOR_IMPL_CLASS = "org.hibernate.validator.HibernateValidator";
    private static final String CONSTRAINT_VIOLATION_EXCEPTION_CLASS = "javax.validation.ConstraintViolationException";

    private ClassConfigPropertiesUtil() {
    }

    static void generateStartupObserverThatInjectsConfigClass(ClassOutput classOutput, Set<DotName> configClasses) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className("io.quarkus.arc.runtime.config.ConfigPropertiesObserver").build();){
            classCreator.addAnnotation(Dependent.class);
            HashMap<DotName, FieldDescriptor> configClassToFieldDescriptor = new HashMap<DotName, FieldDescriptor>(configClasses.size());
            for (DotName configClass : configClasses) {
                String configClassStr = configClass.toString();
                FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator(configClass.isInner() ? configClass.local() : configClass.withoutPackagePrefix() + "_" + HashUtil.sha1((String)configClassStr), configClassStr).setModifiers(1);
                fieldCreator.addAnnotation(Inject.class);
                configClassToFieldDescriptor.put(configClass, fieldCreator.getFieldDescriptor());
            }
            try (MethodCreator methodCreator = classCreator.getMethodCreator("onStartup", Void.TYPE, new Class[]{StartupEvent.class});){
                methodCreator.getParameterAnnotations(0).addAnnotation(Observes.class);
                for (DotName configClass : configClasses) {
                    ResultHandle field = methodCreator.readInstanceField((FieldDescriptor)configClassToFieldDescriptor.get(configClass), methodCreator.getThis());
                    methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)configClass.toString(), (String)"toString", (String)String.class.getName(), (String[])new String[0]), field, new ResultHandle[0]);
                }
                methodCreator.returnValue(null);
            }
        }
    }

    static boolean addProducerMethodForClassConfigProperties(ClassLoader classLoader, ClassInfo configPropertiesClassInfo, ClassCreator producerClassCreator, String prefixStr, IndexView applicationIndex, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        if (!DotNames.OBJECT.equals((Object)configPropertiesClassInfo.superName())) {
            throw new IllegalArgumentException("Classes annotated with @" + DotNames.CONFIG_PROPERTIES + " cannot extend other classes. Offending class is " + configPropertiesClassInfo);
        }
        if (!configPropertiesClassInfo.hasNoArgsConstructor()) {
            throw new IllegalArgumentException("Class " + configPropertiesClassInfo + " which is annotated with " + DotNames.CONFIG_PROPERTIES + " must contain a no-arg constructor");
        }
        if (!Modifier.isPublic(configPropertiesClassInfo.flags())) {
            throw new IllegalArgumentException("Class " + configPropertiesClassInfo + " which is annotated with " + DotNames.CONFIG_PROPERTIES + " must be public");
        }
        String configObjectClassStr = configPropertiesClassInfo.name().toString();
        boolean needsValidation = ClassConfigPropertiesUtil.needsValidation();
        String[] produceMethodParameterTypes = new String[needsValidation ? 2 : 1];
        produceMethodParameterTypes[0] = Config.class.getName();
        if (needsValidation) {
            produceMethodParameterTypes[1] = VALIDATOR_CLASS;
        }
        try (MethodCreator methodCreator = producerClassCreator.getMethodCreator("produce" + configPropertiesClassInfo.name().withoutPackagePrefix(), configObjectClassStr, produceMethodParameterTypes);){
            methodCreator.addAnnotation(Produces.class);
            ResultHandle configObject = ClassConfigPropertiesUtil.populateConfigObject(classLoader, configPropertiesClassInfo, prefixStr, methodCreator, applicationIndex, configProperties);
            if (needsValidation) {
                ClassConfigPropertiesUtil.createValidationCodePath(methodCreator, configObject, prefixStr);
            } else {
                methodCreator.returnValue(configObject);
            }
        }
        return needsValidation;
    }

    private static boolean needsValidation() {
        return ClassConfigPropertiesUtil.isHibernateValidatorInClasspath();
    }

    private static boolean isHibernateValidatorInClasspath() {
        try {
            Class.forName(HIBERNATE_VALIDATOR_IMPL_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ResultHandle populateConfigObject(ClassLoader classLoader, ClassInfo configClassInfo, String prefixStr, MethodCreator methodCreator, IndexView applicationIndex, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        String configObjectClassStr = configClassInfo.name().toString();
        ResultHandle configObject = methodCreator.newInstance(MethodDescriptor.ofConstructor((String)configObjectClassStr, (String[])new String[0]), new ResultHandle[0]);
        ArrayList<ConfigPropertyBuildItemCandidate> configPropertyBuildItemCandidates = new ArrayList<ConfigPropertyBuildItemCandidate>();
        List fields = configClassInfo.fields();
        for (FieldInfo field : fields) {
            Type fieldType;
            boolean useFieldAccess = false;
            String setterName = JavaBeanUtil.getSetterName((String)field.name());
            MethodInfo setter = configClassInfo.method(setterName, new Type[]{fieldType = field.type()});
            if (setter == null) {
                if (!Modifier.isPublic(field.flags()) || Modifier.isFinal(field.flags())) {
                    throw new IllegalArgumentException("Configuration properties class " + configClassInfo + " does not have a setter for field " + field + " nor is the field a public non-final field");
                }
                useFieldAccess = true;
            }
            if (!useFieldAccess && !Modifier.isPublic(setter.flags())) {
                throw new IllegalArgumentException("Setter " + setterName + " of class " + configClassInfo + " must be public");
            }
            DotName fieldTypeDotName = fieldType.name();
            String fieldTypeStr = fieldTypeDotName.toString();
            ClassInfo fieldTypeClassInfo = applicationIndex.getClassByName(fieldType.name());
            if (fieldTypeClassInfo != null) {
                if (!fieldTypeClassInfo.hasNoArgsConstructor()) {
                    throw new IllegalArgumentException("Nested configuration class " + fieldTypeClassInfo + " must contain a no-args constructor ");
                }
                if (!Modifier.isPublic(fieldTypeClassInfo.flags())) {
                    throw new IllegalArgumentException("Nested configuration class " + fieldTypeClassInfo + " must be public ");
                }
                ResultHandle nestedConfigObject = ClassConfigPropertiesUtil.populateConfigObject(classLoader, fieldTypeClassInfo, prefixStr + "." + field.name(), methodCreator, applicationIndex, configProperties);
                ClassConfigPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, nestedConfigObject);
                continue;
            }
            String fullConfigName = prefixStr + "." + field.name();
            ResultHandle config = methodCreator.getMethodParam(0);
            if (DotNames.OPTIONAL.equals((Object)fieldTypeDotName)) {
                Type genericType = ConfigPropertiesUtil.determineSingleGenericType(field.type(), field.declaringClass().name());
                ResultHandle setterValue = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{methodCreator.load(fullConfigName), methodCreator.loadClass(genericType.name().toString())});
                ClassConfigPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, setterValue);
                continue;
            }
            if (ClassConfigPropertiesUtil.shouldCheckForDefaultValue(configClassInfo, field)) {
                String getterName = JavaBeanUtil.getGetterName((String)field.name(), (String)fieldTypeDotName.toString());
                ConfigPropertiesUtil.ReadOptionalResponse readOptionalResponse = ConfigPropertiesUtil.createReadOptionalValueAndConvertIfNeeded(fullConfigName, fieldType, field.declaringClass().name(), (BytecodeCreator)methodCreator, config);
                ClassConfigPropertiesUtil.createWriteValue(readOptionalResponse.getIsPresentTrue(), configObject, field, setter, useFieldAccess, readOptionalResponse.getValue());
                BytecodeCreator isPresentFalse = readOptionalResponse.getIsPresentFalse();
                if (useFieldAccess) {
                    ResultHandle defaultValue = isPresentFalse.readInstanceField(FieldDescriptor.of((FieldInfo)field), configObject);
                } else {
                    ResultHandle resultHandle = isPresentFalse.invokeVirtualMethod(MethodDescriptor.ofMethod((String)configObjectClassStr, (String)getterName, (String)fieldTypeStr, (String[])new String[0]), configObject, new ResultHandle[0]);
                }
            } else {
                ResultHandle setterValue = ConfigPropertiesUtil.createReadMandatoryValueAndConvertIfNeeded(fullConfigName, fieldType, field.declaringClass().name(), (BytecodeCreator)methodCreator, config);
                ClassConfigPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, setterValue);
            }
            configPropertyBuildItemCandidates.add(new ConfigPropertyBuildItemCandidate(field.name(), fullConfigName, fieldTypeStr));
        }
        ConfigPropertyBuildItemCandidateUtil.removePropertiesWithDefaultValue(classLoader, configObjectClassStr, configPropertyBuildItemCandidates);
        for (ConfigPropertyBuildItemCandidate candidate : configPropertyBuildItemCandidates) {
            configProperties.produce((BuildItem)new ConfigPropertyBuildItem(candidate.getConfigPropertyName(), candidate.getConfigPropertyType()));
        }
        return configObject;
    }

    private static void createWriteValue(BytecodeCreator bytecodeCreator, ResultHandle configObject, FieldInfo field, MethodInfo setter, boolean useFieldAccess, ResultHandle value) {
        if (useFieldAccess) {
            ClassConfigPropertiesUtil.createFieldWrite(bytecodeCreator, configObject, field, value);
        } else {
            ClassConfigPropertiesUtil.createSetterCall(bytecodeCreator, configObject, setter, value);
        }
    }

    private static void createSetterCall(BytecodeCreator bytecodeCreator, ResultHandle configObject, MethodInfo setter, ResultHandle value) {
        bytecodeCreator.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)setter), configObject, new ResultHandle[]{value});
    }

    private static void createFieldWrite(BytecodeCreator bytecodeCreator, ResultHandle configObject, FieldInfo field, ResultHandle value) {
        bytecodeCreator.writeInstanceField(FieldDescriptor.of((FieldInfo)field), configObject, value);
    }

    private static boolean shouldCheckForDefaultValue(ClassInfo configPropertiesClassInfo, FieldInfo field) {
        if (field.type().kind() == Type.Kind.PRIMITIVE) {
            return false;
        }
        String getterName = JavaBeanUtil.getGetterName((String)field.name(), (String)field.type().name().toString());
        MethodInfo getterMethod = configPropertiesClassInfo.method(getterName, new Type[0]);
        if (getterMethod != null) {
            return Modifier.isPublic(getterMethod.flags());
        }
        return !Modifier.isFinal(field.flags()) && Modifier.isPublic(field.flags());
    }

    private static void createValidationCodePath(MethodCreator bytecodeCreator, ResultHandle configObject, String configPrefix) {
        ResultHandle validationResult = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)VALIDATOR_CLASS, (String)"validate", Set.class, (Object[])new Object[]{Object.class, Class[].class}), bytecodeCreator.getMethodParam(1), new ResultHandle[]{configObject, bytecodeCreator.newArray(Class.class, bytecodeCreator.load(0))});
        ResultHandle constraintSetIsEmpty = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Set.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), validationResult, new ResultHandle[0]);
        BranchResult constraintSetIsEmptyBranch = bytecodeCreator.ifNonZero(constraintSetIsEmpty);
        constraintSetIsEmptyBranch.trueBranch().returnValue(configObject);
        BytecodeCreator constraintSetIsEmptyFalse = constraintSetIsEmptyBranch.falseBranch();
        ResultHandle exception = constraintSetIsEmptyFalse.newInstance(MethodDescriptor.ofConstructor((String)CONSTRAINT_VIOLATION_EXCEPTION_CLASS, (String[])new String[]{Set.class.getName()}), new ResultHandle[]{validationResult});
        constraintSetIsEmptyFalse.throwException(exception);
    }
}

