/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.configproperties.ClassConfigPropertiesUtil;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.arc.deployment.configproperties.InterfaceConfigPropertiesUtil;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.runtime.util.StringUtil;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ConfigPropertiesBuildStep {
    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndex, ApplicationIndexBuildItem applicationIndex, final BuildProducer<GeneratedClassBuildItem> generatedClasses, final BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ConfigPropertyBuildItem> configProperties, DeploymentClassLoaderBuildItem deploymentClassLoader) {
        IndexView index = combinedIndex.getIndex();
        Collection instances = index.getAnnotations(DotNames.CONFIG_PROPERTIES);
        if (instances.isEmpty()) {
            return;
        }
        ClassOutput beansClassOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedBeans.produce((BuildItem)new GeneratedBeanBuildItem(name, data));
            }
        };
        ClassOutput nonBeansClassOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedClasses.produce((BuildItem)new GeneratedClassBuildItem(true, name, data));
            }
        };
        ClassCreator producerClassCreator = ClassCreator.builder().classOutput(beansClassOutput).className("io.quarkus.arc.runtime.config.ConfigPropertiesProducer").build();
        producerClassCreator.addAnnotation(Singleton.class);
        HashSet<DotName> configClassesThatNeedValidation = new HashSet<DotName>(instances.size());
        for (AnnotationInstance configPropertiesInstance : instances) {
            ClassInfo classInfo = configPropertiesInstance.target().asClass();
            String prefixStr = this.determinePrefix(configPropertiesInstance);
            if (Modifier.isInterface(classInfo.flags())) {
                String generatedClassName = InterfaceConfigPropertiesUtil.generateImplementationForInterfaceConfigProperties(classInfo, nonBeansClassOutput, index, prefixStr, defaultConfigValues, configProperties);
                InterfaceConfigPropertiesUtil.addProducerMethodForInterfaceConfigProperties(producerClassCreator, classInfo.name(), generatedClassName);
                continue;
            }
            boolean needsValidation = ClassConfigPropertiesUtil.addProducerMethodForClassConfigProperties(deploymentClassLoader.getClassLoader(), classInfo, producerClassCreator, prefixStr, (IndexView)applicationIndex.getIndex(), configProperties);
            if (!needsValidation) continue;
            configClassesThatNeedValidation.add(classInfo.name());
        }
        producerClassCreator.close();
        if (!configClassesThatNeedValidation.isEmpty()) {
            ClassConfigPropertiesUtil.generateStartupObserverThatInjectsConfigClass(beansClassOutput, configClassesThatNeedValidation);
        }
    }

    private String determinePrefix(AnnotationInstance configPropertiesInstance) {
        String fromAnnotation = this.getPrefixFromAnnotation(configPropertiesInstance);
        if (fromAnnotation != null) {
            return fromAnnotation;
        }
        return this.getPrefixFromClassName(configPropertiesInstance.target().asClass().name());
    }

    private String getPrefixFromAnnotation(AnnotationInstance configPropertiesInstance) {
        AnnotationValue annotationValue = configPropertiesInstance.value("prefix");
        if (annotationValue == null) {
            return null;
        }
        String value = annotationValue.asString();
        if ("<< unset >>".equals(value) || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private String getPrefixFromClassName(DotName className) {
        String simpleName = className.isInner() ? className.local() : className.withoutPackagePrefix();
        return StringUtil.join((String)"-", (Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)simpleName)), (String[])new String[]{"config", "configuration", "properties", "props"}));
    }
}

