/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesUtil;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class InterfaceConfigPropertiesUtil {
    private InterfaceConfigPropertiesUtil() {
    }

    static void addProducerMethodForInterfaceConfigProperties(ClassCreator classCreator, DotName interfaceName, String generatedClassName) {
        try (MethodCreator method = classCreator.getMethodCreator("produce" + interfaceName.withoutPackagePrefix(), interfaceName.toString(), new String[]{Config.class.getName()});){
            method.addAnnotation(Produces.class);
            method.returnValue(method.newInstance(MethodDescriptor.ofConstructor((Object)generatedClassName, (Object[])new Object[]{Config.class}), new ResultHandle[]{method.getMethodParam(0)}));
        }
    }

    static String generateImplementationForInterfaceConfigProperties(ClassInfo originalInterface, ClassOutput classOutput, IndexView index, String prefixStr, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        HashSet<DotName> allInterfaces = new HashSet<DotName>();
        allInterfaces.add(originalInterface.name());
        InterfaceConfigPropertiesUtil.collectInterfacesRec(originalInterface, index, allInterfaces);
        String generatedClassName = InterfaceConfigPropertiesUtil.createName(originalInterface.name());
        try (ClassCreator interfaceImplClassCreator = ClassCreator.builder().classOutput(classOutput).interfaces(new String[]{originalInterface.name().toString()}).className(generatedClassName).build();){
            FieldDescriptor configField = ((FieldCreator)interfaceImplClassCreator.getFieldCreator("config", Config.class).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator ctor = interfaceImplClassCreator.getMethodCreator("<init>", Void.TYPE, new Class[]{Config.class});){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ResultHandle self = ctor.getThis();
                ResultHandle config = ctor.getMethodParam(0);
                ctor.writeInstanceField(configField, self, config);
                ctor.returnValue(null);
            }
            for (DotName ifaceDotName : allInterfaces) {
                ClassInfo classInfo = index.getClassByName(ifaceDotName);
                List methods = classInfo.methods();
                for (MethodInfo method : methods) {
                    Type returnType = method.returnType();
                    if (InterfaceConfigPropertiesUtil.isDefault(method.flags())) continue;
                    if (!method.parameters().isEmpty()) {
                        throw new IllegalArgumentException("Method " + method.name() + " of interface " + ifaceDotName + " is not a getter method since it defined parameters");
                    }
                    if (returnType.kind() == Type.Kind.VOID) {
                        throw new IllegalArgumentException("Method " + method.name() + " of interface " + ifaceDotName + " is not a getter method since it returns void");
                    }
                    NameAndDefaultValue nameAndDefaultValue = InterfaceConfigPropertiesUtil.determinePropertyNameAndDefaultValue(method);
                    String fullConfigName = prefixStr + "." + nameAndDefaultValue.getName();
                    MethodCreator methodCreator = interfaceImplClassCreator.getMethodCreator(method.name(), method.returnType().name().toString(), new String[0]);
                    Throwable throwable = null;
                    try {
                        ResultHandle config = methodCreator.readInstanceField(configField, methodCreator.getThis());
                        String defaultValueStr = nameAndDefaultValue.getDefaultValue();
                        if (DotNames.OPTIONAL.equals((Object)returnType.name())) {
                            if (defaultValueStr != null) {
                                throw new IllegalArgumentException("Annotating a method returning Optional with @ConfigProperty and setting defaultValue is not supported. Offending method is " + method.name() + " of interface" + ifaceDotName);
                            }
                            Type genericType = ConfigPropertiesUtil.determineSingleGenericType(returnType, method.declaringClass().name());
                            ResultHandle result = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{methodCreator.load(fullConfigName), methodCreator.loadClass(genericType.name().toString())});
                            methodCreator.returnValue(result);
                            continue;
                        }
                        if (defaultValueStr != null) {
                            defaultConfigValues.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(fullConfigName, defaultValueStr));
                        }
                        ResultHandle value = ConfigPropertiesUtil.createReadMandatoryValueAndConvertIfNeeded(fullConfigName, returnType, method.declaringClass().name(), (BytecodeCreator)methodCreator, config);
                        methodCreator.returnValue(value);
                        if (defaultValueStr != null && !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValueStr)) continue;
                        configProperties.produce((BuildItem)new ConfigPropertyBuildItem(fullConfigName, returnType));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (methodCreator == null) continue;
                        if (throwable != null) {
                            try {
                                methodCreator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        methodCreator.close();
                    }
                }
            }
        }
        return generatedClassName;
    }

    private static void collectInterfacesRec(ClassInfo current, IndexView index, Set<DotName> result) {
        List interfaces = current.interfaceNames();
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName iface : interfaces) {
            ClassInfo classByName = index.getClassByName(iface);
            if (classByName == null) {
                throw new IllegalStateException("Unable to collect interfaces of " + iface + " because it was not indexed. Consider adding it to Jandex index");
            }
            result.add(iface);
            InterfaceConfigPropertiesUtil.collectInterfacesRec(classByName, index, result);
        }
    }

    private static String createName(DotName ifaceName) {
        return "io.quarkus.arc.runtime.config." + ifaceName.withoutPackagePrefix() + "_" + HashUtil.sha1((String)ifaceName.toString());
    }

    private static boolean isDefault(short flags) {
        return (flags & 0x409) == 1;
    }

    private static NameAndDefaultValue determinePropertyNameAndDefaultValue(MethodInfo method) {
        AnnotationInstance configPropertyAnnotation = method.annotation(DotNames.CONFIG_PROPERTY);
        if (configPropertyAnnotation != null) {
            AnnotationValue nameValue = configPropertyAnnotation.value("name");
            String name = nameValue == null || nameValue.asString().isEmpty() ? InterfaceConfigPropertiesUtil.getPropertyNameFromMethodName(method) : nameValue.asString();
            AnnotationValue defaultValue = configPropertyAnnotation.value("defaultValue");
            return new NameAndDefaultValue(name, defaultValue != null ? defaultValue.asString() : null);
        }
        return new NameAndDefaultValue(InterfaceConfigPropertiesUtil.getPropertyNameFromMethodName(method));
    }

    private static String getPropertyNameFromMethodName(MethodInfo method) {
        try {
            return JavaBeanUtil.getPropertyNameFromGetter((String)method.name());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method " + method.name() + " of interface " + method.declaringClass() + " is not a getter method. Either rename the method to follow getter name conventions or annotate the method with @ConfigProperty");
        }
    }

    private static class NameAndDefaultValue {
        private final String name;
        private final String defaultValue;

        NameAndDefaultValue(String name) {
            this(name, null);
        }

        NameAndDefaultValue(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

