/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class ArcConfig {
    public static final Set<String> ALLOWED_REMOVE_UNUSED_BEANS_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("all", "true", "none", "false", "fwk", "framework")));
    @ConfigItem(defaultValue="all")
    public String removeUnusedBeans;
    @ConfigItem(defaultValue="true")
    public boolean autoInjectFields;
    @ConfigItem(defaultValue="true")
    public boolean removeFinalForProxyableMethods;

    public final boolean isRemoveUnusedBeansFieldValid() {
        return ALLOWED_REMOVE_UNUSED_BEANS_VALUES.contains(this.removeUnusedBeans.toLowerCase());
    }

    public final boolean shouldEnableBeanRemoval() {
        String lowerCase = this.removeUnusedBeans.toLowerCase();
        return "all".equals(lowerCase) || "true".equals(lowerCase) || "fwk".equals(lowerCase) || "framework".equals(lowerCase);
    }

    public final boolean shouldOnlyKeepAppBeans() {
        String lowerCase = this.removeUnusedBeans.toLowerCase();
        return "fwk".equals(lowerCase) || "framework".equals(lowerCase);
    }
}

