/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.util.StringUtil;
import java.util.Iterator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class ConfigPropertiesMetadataBuildItem
extends MultiBuildItem {
    private static final DotName CONFIG_PROPERTIES_ANNOTATION = DotName.createSimple((String)ConfigProperties.class.getName());
    private final ClassInfo classInfo;
    private final String prefix;
    private final ConfigProperties.NamingStrategy namingStrategy;

    public ConfigPropertiesMetadataBuildItem(AnnotationInstance annotation, ConfigProperties.NamingStrategy defaultStrategy) {
        if (!CONFIG_PROPERTIES_ANNOTATION.equals((Object)annotation.name())) {
            throw new IllegalArgumentException(annotation + " is not an instance of " + ConfigProperties.class.getSimpleName());
        }
        this.classInfo = annotation.target().asClass();
        this.prefix = this.extractPrefix(annotation);
        AnnotationValue namingStrategyValue = annotation.value("namingStrategy");
        this.namingStrategy = namingStrategyValue == null ? defaultStrategy : ConfigProperties.NamingStrategy.valueOf((String)namingStrategyValue.asEnum());
    }

    public ConfigPropertiesMetadataBuildItem(ClassInfo classInfo, String prefix, ConfigProperties.NamingStrategy namingStrategy) {
        this.classInfo = classInfo;
        this.prefix = this.sanitisePrefix(prefix);
        this.namingStrategy = namingStrategy;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ConfigProperties.NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    private String extractPrefix(AnnotationInstance annotationInstance) {
        AnnotationValue value = annotationInstance.value("prefix");
        return this.sanitisePrefix(value == null ? null : value.asString());
    }

    private String sanitisePrefix(String prefix) {
        if (this.isPrefixUnset(prefix)) {
            return this.getPrefixFromClassName(this.classInfo.name());
        }
        return prefix;
    }

    private boolean isPrefixUnset(String prefix) {
        return prefix == null || "".equals(prefix.trim()) || "<< unset >>".equals(prefix.trim());
    }

    private String getPrefixFromClassName(DotName className) {
        String simpleName = className.isInner() ? className.local() : className.withoutPackagePrefix();
        return StringUtil.join((String)"-", (Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)simpleName)), (String[])new String[]{"config", "configuration", "properties", "props"}));
    }
}

