/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.arc.profile.UnlessBuildProfile;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.configuration.ProfileManager;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class BuildProfileProcessor {
    private static final DotName IF_BUILD_PROFILE = DotName.createSimple((String)IfBuildProfile.class.getName());
    private static final DotName UNLESS_BUILD_PROFILE = DotName.createSimple((String)UnlessBuildProfile.class.getName());

    @BuildStep
    void ifBuildProfile(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD || kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                AnnotationInstance enableOnBuildProfile = Annotations.find((Collection)ctx.getAnnotations(), (DotName)IF_BUILD_PROFILE);
                if (enableOnBuildProfile == null) {
                    return;
                }
                Transformation transform = ctx.transform();
                String profileOnInstance = enableOnBuildProfile.value().asString();
                if (profileOnInstance.equals(ProfileManager.getActiveProfile())) {
                    transform.add(DotNames.ALTERNATIVE_PRIORITY, new AnnotationValue[]{BuildProfileProcessor.this.createAlternativePriority()});
                } else {
                    transform.add(DotNames.ALTERNATIVE, new AnnotationValue[0]);
                }
                transform.done();
            }
        }));
    }

    @BuildStep
    void unlessBuildProfile(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD || kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                AnnotationInstance unlessBuildProfile = Annotations.find((Collection)ctx.getAnnotations(), (DotName)UNLESS_BUILD_PROFILE);
                if (unlessBuildProfile == null) {
                    return;
                }
                Transformation transform = ctx.transform();
                String profileOnInstance = unlessBuildProfile.value().asString();
                if (profileOnInstance.equals(ProfileManager.getActiveProfile())) {
                    transform.add(DotNames.ALTERNATIVE, new AnnotationValue[0]);
                } else {
                    transform.add(DotNames.ALTERNATIVE_PRIORITY, new AnnotationValue[]{BuildProfileProcessor.this.createAlternativePriority()});
                }
                transform.done();
            }
        }));
    }

    private AnnotationValue createAlternativePriority() {
        return AnnotationValue.createIntegerValue((String)"value", (int)0x7FFFFFFE);
    }
}

