/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.arc.profile.UnlessBuildProfile;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.runtime.configuration.ProfileManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class BuildTimeEnabledProcessor {
    private static final Logger LOGGER = Logger.getLogger(BuildTimeEnabledProcessor.class);
    private static final DotName IF_BUILD_PROFILE = DotName.createSimple((String)IfBuildProfile.class.getName());
    private static final DotName UNLESS_BUILD_PROFILE = DotName.createSimple((String)UnlessBuildProfile.class.getName());
    private static final DotName IF_BUILD_PROPERTY = DotName.createSimple((String)IfBuildProperty.class.getName());

    @BuildStep
    void ifBuildProfile(CombinedIndexBuildItem index, BuildProducer<BuildTimeConditionBuildItem> producer) {
        Collection annotationInstances = index.getIndex().getAnnotations(IF_BUILD_PROFILE);
        for (AnnotationInstance instance : annotationInstances) {
            String profileOnInstance = instance.value().asString();
            boolean enabled = profileOnInstance.equals(ProfileManager.getActiveProfile());
            if (enabled) {
                LOGGER.debug((Object)("Enabling " + instance + " since the profile value matches the active profile."));
            } else {
                LOGGER.debug((Object)("Disabling " + instance + " since the profile value does not match the active profile."));
            }
            producer.produce((BuildItem)new BuildTimeConditionBuildItem(instance.target(), enabled));
        }
    }

    @BuildStep
    void unlessBuildProfile(CombinedIndexBuildItem index, BuildProducer<BuildTimeConditionBuildItem> producer) {
        Collection annotationInstances = index.getIndex().getAnnotations(UNLESS_BUILD_PROFILE);
        for (AnnotationInstance instance : annotationInstances) {
            boolean enabled;
            String profileOnInstance = instance.value().asString();
            boolean bl = enabled = !profileOnInstance.equals(ProfileManager.getActiveProfile());
            if (enabled) {
                LOGGER.debug((Object)("Enabling " + instance + " since the profile value does not match the active profile."));
            } else {
                LOGGER.debug((Object)("Disabling " + instance + " since the profile value matches the active profile."));
            }
            producer.produce((BuildItem)new BuildTimeConditionBuildItem(instance.target(), enabled));
        }
    }

    @BuildStep
    void ifBuildProperty(BeanArchiveIndexBuildItem index, BuildProducer<BuildTimeConditionBuildItem> producer) {
        Config config = ConfigProviderResolver.instance().getConfig();
        Collection annotationInstances = index.getIndex().getAnnotations(IF_BUILD_PROPERTY);
        for (AnnotationInstance instance : annotationInstances) {
            boolean enabled;
            String propertyName = instance.value("name").asString();
            String expectedStringValue = instance.value("stringValue").asString();
            AnnotationValue enableIfMissingValue = instance.value("enableIfMissing");
            boolean enableIfMissing = enableIfMissingValue != null && enableIfMissingValue.asBoolean();
            Optional optionalValue = config.getOptionalValue(propertyName, String.class);
            if (optionalValue.isPresent()) {
                if (((String)optionalValue.get()).equals(expectedStringValue)) {
                    LOGGER.debug((Object)("Enabling " + instance + " since the property value matches the expected one."));
                    enabled = true;
                } else {
                    LOGGER.debug((Object)("Disabling " + instance + " since the property value does not match the expected one."));
                    enabled = false;
                }
            } else if (enableIfMissing) {
                LOGGER.debug((Object)("Enabling " + instance + " since the property has not been set and 'enableIfMissing' is set to 'true'."));
                enabled = true;
            } else {
                LOGGER.debug((Object)("Disabling " + instance + " since the property has not been set and 'enableIfMissing' is set to 'false'."));
                enabled = false;
            }
            producer.produce((BuildItem)new BuildTimeConditionBuildItem(instance.target(), enabled));
        }
    }

    @BuildStep
    void conditionTransformer(List<BuildTimeConditionBuildItem> buildTimeConditions, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (buildTimeConditions.isEmpty()) {
            return;
        }
        final HashMap<DotName, Boolean> classTargets = new HashMap<DotName, Boolean>();
        final HashMap<String, Boolean> fieldTargets = new HashMap<String, Boolean>();
        final HashMap<MethodInfo, Boolean> methodTargets = new HashMap<MethodInfo, Boolean>();
        for (BuildTimeConditionBuildItem buildTimeCondition : buildTimeConditions) {
            String uniqueFieldName;
            Boolean allPreviousConditionsTrue;
            AnnotationTarget target = buildTimeCondition.getTarget();
            AnnotationTarget.Kind kind = target.kind();
            if (kind == AnnotationTarget.Kind.CLASS) {
                DotName classDotName;
                allPreviousConditionsTrue = classTargets.getOrDefault(classDotName = target.asClass().name(), true);
                classTargets.put(classDotName, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
                continue;
            }
            if (kind == AnnotationTarget.Kind.METHOD) {
                MethodInfo method;
                allPreviousConditionsTrue = methodTargets.getOrDefault(method = target.asMethod(), true);
                methodTargets.put(method, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
                continue;
            }
            if (kind != AnnotationTarget.Kind.FIELD) continue;
            allPreviousConditionsTrue = fieldTargets.getOrDefault(uniqueFieldName = this.toUniqueString(target.asField()), true);
            fieldTargets.put(uniqueFieldName, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                FieldInfo field;
                String uniqueFieldName;
                AnnotationTarget target = ctx.getTarget();
                if (ctx.isClass()) {
                    DotName classDotName = target.asClass().name();
                    if (classTargets.containsKey(classDotName)) {
                        BuildTimeEnabledProcessor.this.transformBean(target, ctx.transform(), (Boolean)classTargets.get(classDotName));
                    }
                } else if (ctx.isMethod()) {
                    MethodInfo method = target.asMethod();
                    if (methodTargets.containsKey(method)) {
                        BuildTimeEnabledProcessor.this.transformBean(target, ctx.transform(), (Boolean)methodTargets.get(method));
                    }
                } else if (ctx.isField() && fieldTargets.containsKey(uniqueFieldName = BuildTimeEnabledProcessor.this.toUniqueString(field = target.asField()))) {
                    BuildTimeEnabledProcessor.this.transformBean(target, ctx.transform(), (Boolean)fieldTargets.get(uniqueFieldName));
                }
            }
        }));
    }

    private String toUniqueString(FieldInfo field) {
        return field.declaringClass().name().toString() + "." + field.name();
    }

    private void transformBean(AnnotationTarget target, Transformation transform, boolean enable) {
        if (enable) {
            this.enableBean(transform);
        } else {
            this.disableBean(target, transform);
        }
        transform.done();
    }

    private void enableBean(Transformation transform) {
        transform.add(DotNames.ALTERNATIVE_PRIORITY, new AnnotationValue[]{this.createAlternativePriority()});
    }

    private AnnotationValue createAlternativePriority() {
        return AnnotationValue.createIntegerValue((String)"value", (int)0x7FFFFFFE);
    }

    private void disableBean(AnnotationTarget target, Transformation transform) {
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            transform.add(DotNames.VETOED, new AnnotationValue[0]);
        } else {
            transform.add(DotNames.ALTERNATIVE, new AnnotationValue[0]);
        }
    }
}

