/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import io.quarkus.arc.deployment.devconsole.DevBeanInfos;
import io.quarkus.arc.deployment.devconsole.DevObserverInfo;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.ArcContainerSupplier;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.arc.runtime.BeanLookupSupplier;
import io.quarkus.arc.runtime.devconsole.EventsMonitor;
import io.quarkus.arc.runtime.devconsole.InvocationInterceptor;
import io.quarkus.arc.runtime.devconsole.InvocationTree;
import io.quarkus.arc.runtime.devconsole.InvocationsMonitor;
import io.quarkus.arc.runtime.devconsole.Monitored;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class ArcDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public DevConsoleRuntimeTemplateInfoBuildItem exposeArcContainer(ArcRecorder recorder) {
        return new DevConsoleRuntimeTemplateInfoBuildItem("arcContainer", (Supplier)new ArcContainerSupplier());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void monitor(ArcConfig config, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> runtimeInfos, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AnnotationsTransformerBuildItem> annotationTransformers, final CustomScopeAnnotationsBuildItem customScopes, final List<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        if (!config.devMode.monitoringEnabled) {
            return;
        }
        if (!config.transformUnproxyableClasses) {
            throw new IllegalStateException("Dev UI problem: monitoring of CDI business method invocations not possible\n\t- quarkus.arc.transform-unproxyable-classes was set to false and therefore it would not be possible to apply interceptors to unproxyable bean classes\n\t- please disable the monitoring feature via quarkus.arc.dev-mode.monitoring-enabled=false or enable unproxyable classes transformation");
        }
        runtimeInfos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("eventsMonitor", (Supplier)new BeanLookupSupplier(EventsMonitor.class)));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EventsMonitor.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(InvocationTree.class, InvocationsMonitor.class, InvocationInterceptor.class, Monitored.class).build());
        final HashSet<DotName> skipNames = new HashSet<DotName>();
        skipNames.add(DotName.createSimple((String)InvocationTree.class.getName()));
        skipNames.add(DotName.createSimple((String)InvocationsMonitor.class.getName()));
        skipNames.add(DotName.createSimple((String)EventsMonitor.class.getName()));
        annotationTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo beanClass;
                if (transformationContext.isClass() && (customScopes.isScopeDeclaredOn(beanClass = transformationContext.getTarget().asClass()) || ArcDevConsoleProcessor.this.isAdditionalBeanDefiningAnnotationOn(beanClass, beanDefiningAnnotations)) && !skipNames.contains(beanClass.name())) {
                    ((Transformation)transformationContext.transform().add(Monitored.class, new AnnotationValue[0])).done();
                }
            }
        }));
        runtimeInfos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("invocationsMonitor", (Supplier)new BeanLookupSupplier(InvocationsMonitor.class)));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleTemplateInfoBuildItem collectBeanInfo(ValidationPhaseBuildItem validationPhaseBuildItem, CompletedApplicationClassPredicateBuildItem predicate) {
        BeanDeploymentValidator.ValidationContext validationContext = validationPhaseBuildItem.getContext();
        DevBeanInfos beanInfos = new DevBeanInfos();
        for (BeanInfo beanInfo : validationContext.beans()) {
            beanInfos.addBean(DevBeanInfo.from(beanInfo, predicate));
        }
        for (BeanInfo beanInfo : validationContext.removedBeans()) {
            beanInfos.addRemovedBean(DevBeanInfo.from(beanInfo, predicate));
        }
        for (ObserverInfo observerInfo : (Collection)validationContext.get(BuildExtension.Key.OBSERVERS)) {
            beanInfos.addObserver(DevObserverInfo.from(observerInfo, predicate));
        }
        beanInfos.sort();
        return new DevConsoleTemplateInfoBuildItem("devBeanInfos", (Object)beanInfos);
    }

    private boolean isAdditionalBeanDefiningAnnotationOn(ClassInfo beanClass, List<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        for (BeanDefiningAnnotationBuildItem beanDefiningAnnotation : beanDefiningAnnotations) {
            if (beanClass.classAnnotation(beanDefiningAnnotation.getName()) == null) continue;
            return true;
        }
        return false;
    }
}

