/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class SplitPackageProcessor {
    private static final Logger LOGGER = Logger.getLogger(SplitPackageProcessor.class);
    private static final Predicate<String> IGNORE_PACKAGE = new Predicate<String>(){

        @Override
        public boolean test(String packageName) {
            return packageName.startsWith("io.fabric8.kubernetes") || packageName.equals("io.quarkus.hibernate.orm.panache") || packageName.equals("io.quarkus.mongodb.panache.reactive") || packageName.equals("io.quarkus.mongodb.panache");
        }
    };

    @BuildStep
    void splitPackageDetection(ApplicationArchivesBuildItem archivesBuildItem, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> dummy) {
        HashMap<String, Set> packageToArchiveMap = new HashMap<String, Set>();
        for (ApplicationArchive archive : archivesBuildItem.getAllApplicationArchives()) {
            for (ClassInfo classInfo : archive.getIndex().getKnownClasses()) {
                String packageName = DotNames.packageName((DotName)classInfo.name());
                packageToArchiveMap.compute(packageName, (key, val) -> {
                    Set returnValue = val == null ? new HashSet() : val;
                    returnValue.add(archive);
                    return returnValue;
                });
            }
        }
        StringBuilder splitPackagesWarning = new StringBuilder();
        for (String packageName : packageToArchiveMap.keySet()) {
            Set applicationArchives;
            if (IGNORE_PACKAGE.test(packageName) || (applicationArchives = (Set)packageToArchiveMap.get(packageName)).size() <= 1) continue;
            splitPackagesWarning.append("\n- \"" + packageName + "\" found in ");
            Iterator iterator = applicationArchives.iterator();
            TreeSet<Object> splitPackages = new TreeSet<Object>();
            while (iterator.hasNext()) {
                ApplicationArchive next = (ApplicationArchive)iterator.next();
                AppArtifactKey a = next.getArtifactKey();
                if (a == null) {
                    if (archivesBuildItem.getRootArchive().equals(next)) {
                        splitPackages.add("application classes");
                        continue;
                    }
                    Iterator pathIterator = next.getPaths().iterator();
                    if (pathIterator.hasNext()) {
                        splitPackages.add(((Path)pathIterator.next()).toString());
                        continue;
                    }
                    splitPackages.add("unknown archive");
                    continue;
                }
                splitPackages.add(a.getGroupId() + ":" + a.getArtifactId());
            }
            splitPackagesWarning.append(splitPackages.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        if (splitPackagesWarning.length() > 0) {
            LOGGER.warnf("Detected a split package usage which is considered a bad practice and should be avoided. Following packages were detected in multiple archives: %s", (Object)splitPackagesWarning.toString());
        }
    }
}

