/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

class YamlListObjectHandler {
    private static final String ABSTRACT_YAML_CONVERTER_CNAME = "io.quarkus.config.yaml.runtime.AbstractYamlObjectConverter";
    private final ClassOutput classOutput;
    private final IndexView index;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClasses;
    private static final String ILLEGAL_ARGUMENT_MESSAGE = "YamlListObjectHandler can only be used for fields / methods that are of type 'List<SomeClass>' where 'SomeClass' is an application class";

    public YamlListObjectHandler(ClassOutput classOutput, IndexView index, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        this.classOutput = classOutput;
        this.index = index;
        this.reflectiveClasses = reflectiveClasses;
    }

    public ResultHandle handle(Member member, MethodCreator configPopulator, ResultHandle configObject, String configName, String fullConfigName) {
        MethodDescriptor getterDesc;
        ClassInfo classInfo = this.validateType(member.type());
        this.validateClass(classInfo, member);
        this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{classInfo.name().toString()}));
        String wrapperClassName = classInfo.name().toString() + "_GeneratedListWrapper_" + configName;
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(wrapperClassName).build();){
            FieldDescriptor fieldDesc = ((FieldCreator)cc.getFieldCreator(configName, List.class).setModifiers(2)).getFieldDescriptor();
            MethodCreator getter = cc.getMethodCreator(JavaBeanUtil.getGetterName((String)configName, (DotName)classInfo.name()), List.class, new Class[0]);
            getter.setSignature(String.format("()Ljava/util/List<L%s;>;", this.forSignature(classInfo)));
            getterDesc = getter.getMethodDescriptor();
            getter.returnValue(getter.readInstanceField(fieldDesc, getter.getThis()));
            MethodCreator setter = cc.getMethodCreator(JavaBeanUtil.getSetterName((String)configName), Void.TYPE, new Class[]{List.class});
            setter.setSignature(String.format("(Ljava/util/List<L%s;>;)V", this.forSignature(classInfo)));
            setter.writeInstanceField(fieldDesc, setter.getThis(), setter.getMethodParam(0));
            setter.returnValue(null);
        }
        this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{wrapperClassName}));
        String wrapperConverterClassName = wrapperClassName + "_Converter";
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(wrapperConverterClassName).superClass(ABSTRACT_YAML_CONVERTER_CNAME).signature(String.format("L%s<L%s;>;", ABSTRACT_YAML_CONVERTER_CNAME.replace('.', '/'), wrapperClassName.replace('.', '/'))).build();){
            MethodCreator getClazz = (MethodCreator)cc.getMethodCreator("getClazz", Class.class, new Class[0]).setModifiers(4);
            getClazz.returnValue(getClazz.loadClassFromTCCL(wrapperClassName));
            List configPropertyInstances = (List)classInfo.annotations().get(DotNames.CONFIG_PROPERTY);
            HashMap<String, String> fieldNameMap = new HashMap<String, String>();
            if (configPropertyInstances != null) {
                for (AnnotationInstance instance : configPropertyInstances) {
                    String nameValueStr;
                    AnnotationValue nameValue;
                    if (instance.target().kind() != AnnotationTarget.Kind.FIELD || (nameValue = instance.value("name")) == null || (nameValueStr = nameValue.asString()) == null || nameValueStr.isEmpty()) continue;
                    String annotatedFieldName = instance.target().asField().name();
                    fieldNameMap.put(nameValueStr, annotatedFieldName);
                }
            }
            if (!fieldNameMap.isEmpty()) {
                MethodCreator getFieldNameMap = cc.getMethodCreator("getFieldNameMap", Map.class, new Class[0]);
                ResultHandle resultHandle = getFieldNameMap.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (Map.Entry entry : fieldNameMap.entrySet()) {
                    getFieldNameMap.invokeVirtualMethod(MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), resultHandle, new ResultHandle[]{getFieldNameMap.load((String)entry.getKey()), getFieldNameMap.load((String)entry.getValue())});
                }
                getFieldNameMap.returnValue(resultHandle);
            }
        }
        ResultHandle smallryeConfig = configPopulator.checkCast(configObject, SmallRyeConfig.class);
        ResultHandle getValueHandle = configPopulator.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class, Converter.class}), smallryeConfig, new ResultHandle[]{configPopulator.load(fullConfigName), configPopulator.newInstance(MethodDescriptor.ofConstructor((String)wrapperConverterClassName, (String[])new String[0]), new ResultHandle[0])});
        ResultHandle wrapperHandle = configPopulator.checkCast(getValueHandle, wrapperClassName);
        return configPopulator.invokeVirtualMethod(getterDesc, wrapperHandle, new ResultHandle[0]);
    }

    private void validateClass(ClassInfo classInfo, Member member) {
        if (Modifier.isInterface(classInfo.flags())) {
            throw new IllegalArgumentException("The use of interfaces as the generic type of Lists fields / methods is not allowed. Offending field is '" + member.name() + "' of class '" + member.declaringClass().name().toString() + "'");
        }
        if (!classInfo.hasNoArgsConstructor()) {
            throw new IllegalArgumentException(String.format("Class '%s' which is used as %s in class '%s' must have a no-args constructor", classInfo, member.phraseUsage(), member.declaringClass().name().toString()));
        }
        if (!Modifier.isPublic(classInfo.flags())) {
            throw new IllegalArgumentException(String.format("Class '%s' which is used as %s in class '%s' must be a public class", classInfo, member.phraseUsage(), member.declaringClass().name().toString()));
        }
    }

    private ClassInfo validateType(Type type) {
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_MESSAGE);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (!DotNames.LIST.equals((Object)parameterizedType.name())) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_MESSAGE);
        }
        if (parameterizedType.arguments().size() != 1) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_MESSAGE);
        }
        ClassInfo classInfo = this.index.getClassByName(((Type)parameterizedType.arguments().get(0)).name());
        if (classInfo == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_MESSAGE);
        }
        return classInfo;
    }

    private String forSignature(ClassInfo classInfo) {
        return classInfo.name().toString().replace('.', '/');
    }

    static class MethodReturnTypeMember
    extends Member {
        public MethodReturnTypeMember(MethodInfo methodInfo) {
            super(methodInfo.declaringClass(), methodInfo.returnType(), methodInfo.name());
        }

        @Override
        protected String phraseUsage() {
            return "return type of method '" + this.name() + "'";
        }
    }

    static class FieldMember
    extends Member {
        public FieldMember(FieldInfo fieldInfo) {
            super(fieldInfo.declaringClass(), fieldInfo.type(), fieldInfo.name());
        }

        @Override
        protected String phraseUsage() {
            return "field '" + this.name() + "'";
        }
    }

    static abstract class Member {
        private final ClassInfo declaringClass;
        private final Type type;
        private final String name;

        protected abstract String phraseUsage();

        public Member(ClassInfo declaringClass, Type type, String name) {
            this.declaringClass = declaringClass;
            this.type = type;
            this.name = name;
        }

        public ClassInfo declaringClass() {
            return this.declaringClass;
        }

        public Type type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }
    }
}

