/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.devconsole.DependencyGraph;
import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import io.quarkus.arc.deployment.devconsole.DevBeanInfos;
import io.quarkus.arc.deployment.devconsole.DevDecoratorInfo;
import io.quarkus.arc.deployment.devconsole.DevInterceptorInfo;
import io.quarkus.arc.deployment.devconsole.DevObserverInfo;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.ArcContainerSupplier;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.arc.runtime.BeanLookupSupplier;
import io.quarkus.arc.runtime.devconsole.EventsMonitor;
import io.quarkus.arc.runtime.devconsole.InvocationInterceptor;
import io.quarkus.arc.runtime.devconsole.InvocationTree;
import io.quarkus.arc.runtime.devconsole.InvocationsMonitor;
import io.quarkus.arc.runtime.devconsole.Monitored;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class ArcDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public DevConsoleRuntimeTemplateInfoBuildItem exposeArcContainer(ArcRecorder recorder, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        return new DevConsoleRuntimeTemplateInfoBuildItem("arcContainer", (Supplier)new ArcContainerSupplier(), this.getClass(), curateOutcomeBuildItem);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void monitor(ArcConfig config, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> runtimeInfos, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AnnotationsTransformerBuildItem> annotationTransformers, final CustomScopeAnnotationsBuildItem customScopes, final List<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!config.devMode.monitoringEnabled) {
            return;
        }
        if (!config.transformUnproxyableClasses) {
            throw new IllegalStateException("Dev UI problem: monitoring of CDI business method invocations not possible\n\t- quarkus.arc.transform-unproxyable-classes was set to false and therefore it would not be possible to apply interceptors to unproxyable bean classes\n\t- please disable the monitoring feature via quarkus.arc.dev-mode.monitoring-enabled=false or enable unproxyable classes transformation");
        }
        runtimeInfos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("eventsMonitor", (Supplier)new BeanLookupSupplier(EventsMonitor.class), this.getClass(), curateOutcomeBuildItem));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EventsMonitor.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(InvocationTree.class, InvocationsMonitor.class, InvocationInterceptor.class, Monitored.class).build());
        final HashSet<DotName> skipNames = new HashSet<DotName>();
        skipNames.add(DotName.createSimple((String)InvocationTree.class.getName()));
        skipNames.add(DotName.createSimple((String)InvocationsMonitor.class.getName()));
        skipNames.add(DotName.createSimple((String)EventsMonitor.class.getName()));
        annotationTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo beanClass;
                if (transformationContext.isClass() && (customScopes.isScopeDeclaredOn(beanClass = transformationContext.getTarget().asClass()) || ArcDevConsoleProcessor.this.isAdditionalBeanDefiningAnnotationOn(beanClass, beanDefiningAnnotations)) && !skipNames.contains(beanClass.name())) {
                    ((Transformation)transformationContext.transform().add(Monitored.class, new AnnotationValue[0])).done();
                }
            }
        }));
        runtimeInfos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("invocationsMonitor", (Supplier)new BeanLookupSupplier(InvocationsMonitor.class), this.getClass(), curateOutcomeBuildItem));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleTemplateInfoBuildItem collectBeanInfo(ValidationPhaseBuildItem validationPhaseBuildItem, CompletedApplicationClassPredicateBuildItem predicate) {
        BeanDeploymentValidator.ValidationContext validationContext = validationPhaseBuildItem.getContext();
        DevBeanInfos beanInfos = new DevBeanInfos();
        for (BeanInfo bean : validationContext.beans()) {
            beanInfos.addBean(DevBeanInfo.from(bean, predicate));
        }
        for (BeanInfo bean : validationContext.removedBeans()) {
            beanInfos.addRemovedBean(DevBeanInfo.from(bean, predicate));
        }
        for (ObserverInfo observer : (Collection)validationContext.get(BuildExtension.Key.OBSERVERS)) {
            beanInfos.addObserver(DevObserverInfo.from(observer, predicate));
        }
        for (Object interceptor : (Collection)validationContext.get(BuildExtension.Key.INTERCEPTORS)) {
            beanInfos.addInterceptor(DevInterceptorInfo.from((InterceptorInfo)interceptor, predicate));
        }
        Collection removedInterceptors = (Collection)validationContext.get(BuildExtension.Key.REMOVED_INTERCEPTORS);
        if (removedInterceptors != null) {
            for (InterceptorInfo interceptor : removedInterceptors) {
                beanInfos.addRemovedInterceptor(DevInterceptorInfo.from(interceptor, predicate));
            }
        }
        for (Object decorator : (Collection)validationContext.get(BuildExtension.Key.DECORATORS)) {
            beanInfos.addDecorator(DevDecoratorInfo.from((DecoratorInfo)decorator, predicate));
        }
        Collection removedDecorators = (Collection)validationContext.get(BuildExtension.Key.REMOVED_DECORATORS);
        if (removedDecorators != null) {
            for (DecoratorInfo decorator : removedDecorators) {
                beanInfos.addRemovedDecorator(DevDecoratorInfo.from(decorator, predicate));
            }
        }
        BeanResolver resolver = validationPhaseBuildItem.getBeanResolver();
        for (BeanInfo bean : validationContext.beans()) {
            beanInfos.addDependencyGraph(bean.getIdentifier(), this.buildDependencyGraph(bean, validationContext, resolver, beanInfos));
        }
        beanInfos.sort();
        return new DevConsoleTemplateInfoBuildItem("devBeanInfos", (Object)beanInfos);
    }

    private boolean isAdditionalBeanDefiningAnnotationOn(ClassInfo beanClass, List<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        for (BeanDefiningAnnotationBuildItem beanDefiningAnnotation : beanDefiningAnnotations) {
            if (beanClass.classAnnotation(beanDefiningAnnotation.getName()) == null) continue;
            return true;
        }
        return false;
    }

    DependencyGraph buildDependencyGraph(BeanInfo bean, BeanDeploymentValidator.ValidationContext validationContext, BeanResolver resolver, DevBeanInfos devBeanInfos) {
        HashSet<DevBeanInfo> nodes = new HashSet<DevBeanInfo>();
        Collection beans = (Collection)validationContext.get(BuildExtension.Key.BEANS);
        HashSet<DependencyGraph.Link> links = new HashSet<DependencyGraph.Link>();
        Map declaringToProducers = (Map)validationContext.beans().producers().collect(Collectors.groupingBy(BeanInfo::getDeclaringBean));
        this.addNodesDependencies(bean, nodes, links, bean, devBeanInfos);
        this.addNodesDependents(bean, nodes, links, bean, beans, declaringToProducers, resolver, devBeanInfos);
        return new DependencyGraph(nodes, links);
    }

    void addNodesDependencies(BeanInfo root, Set<DevBeanInfo> nodes, Set<DependencyGraph.Link> links, BeanInfo bean, DevBeanInfos devBeanInfos) {
        if (nodes.add(devBeanInfos.getBean(bean.getIdentifier()))) {
            if (bean.isProducerField() || bean.isProducerMethod()) {
                links.add(DependencyGraph.Link.producer(bean.getIdentifier(), bean.getDeclaringBean().getIdentifier()));
                this.addNodesDependencies(root, nodes, links, bean.getDeclaringBean(), devBeanInfos);
            }
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                BeanInfo resolved = injectionPoint.getResolvedBean();
                if (resolved == null || resolved.equals((Object)bean)) continue;
                links.add(DependencyGraph.Link.dependency(root.equals((Object)bean), bean.getIdentifier(), resolved.getIdentifier()));
                this.addNodesDependencies(root, nodes, links, injectionPoint.getResolvedBean(), devBeanInfos);
            }
        }
    }

    void addNodesDependents(BeanInfo root, Set<DevBeanInfo> nodes, Set<DependencyGraph.Link> links, BeanInfo bean, Collection<BeanInfo> beans, Map<BeanInfo, List<BeanInfo>> declaringToProducers, BeanResolver resolver, DevBeanInfos devBeanInfos) {
        for (BeanInfo dependent : beans) {
            if (bean.equals((Object)dependent)) continue;
            for (InjectionPointInfo injectionPoint : dependent.getAllInjectionPoints()) {
                DependencyGraph.Link link = null;
                if (injectionPoint.isProgrammaticLookup()) {
                    if (resolver.matches(bean, (Type)injectionPoint.getType().asParameterizedType().arguments().get(0), injectionPoint.getRequiredQualifiers())) {
                        link = DependencyGraph.Link.lookup(dependent.getIdentifier(), bean.getIdentifier());
                    }
                } else if (bean.equals((Object)injectionPoint.getResolvedBean())) {
                    link = DependencyGraph.Link.dependent(root.equals((Object)bean), dependent.getIdentifier(), bean.getIdentifier());
                }
                if (link == null) continue;
                links.add(link);
                if (!nodes.add(devBeanInfos.getBean(dependent.getIdentifier()))) continue;
                this.addNodesDependents(root, nodes, links, dependent, beans, declaringToProducers, resolver, devBeanInfos);
            }
        }
        for (BeanInfo producer : declaringToProducers.getOrDefault(bean, Collections.emptyList())) {
            links.add(DependencyGraph.Link.producer(producer.getIdentifier(), bean.getIdentifier()));
            if (!nodes.add(devBeanInfos.getBean(producer.getIdentifier()))) continue;
            this.addNodesDependents(root, nodes, links, producer, beans, declaringToProducers, resolver, devBeanInfos);
        }
    }
}

