/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.AsyncObserverExceptionHandler;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AdditionalStereotypeBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CurrentContextFactoryBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.deployment.ExcludedTypeBuildItem;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ObserverTransformerBuildItem;
import io.quarkus.arc.deployment.PreBeanContainerBuildItem;
import io.quarkus.arc.deployment.QualifierRegistrarBuildItem;
import io.quarkus.arc.deployment.ReflectiveBeanClassBuildItem;
import io.quarkus.arc.deployment.ResourceAnnotationBuildItem;
import io.quarkus.arc.deployment.StereotypeRegistrarBuildItem;
import io.quarkus.arc.deployment.SuppressConditionGeneratorBuildItem;
import io.quarkus.arc.deployment.SynthesisFinishedBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AlternativePriorities;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ObserverRegistrar;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.StereotypeRegistrar;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.processor.Types;
import io.quarkus.arc.runtime.AdditionalBean;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.LaunchModeProducer;
import io.quarkus.arc.runtime.LoggerProducer;
import io.quarkus.arc.runtime.appcds.AppCDSRecorder;
import io.quarkus.arc.runtime.context.ArcContextProvider;
import io.quarkus.arc.runtime.test.PreloadedTestApplicationClassPredicate;
import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.pkg.builditem.AppCDSControlPointBuildItem;
import io.quarkus.deployment.pkg.builditem.AppCDSRequestedBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.QuarkusMain;
import io.quarkus.runtime.test.TestApplicationClassPredicate;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.smallrye.context.deployment.spi.ThreadContextProviderBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ArcProcessor {
    private static final Logger LOGGER = Logger.getLogger(ArcProcessor.class);
    static final DotName ADDITIONAL_BEAN = DotName.createSimple((String)AdditionalBean.class.getName());
    static final DotName ASYNC_OBSERVER_EXCEPTION_HANDLER = DotName.createSimple((String)AsyncObserverExceptionHandler.class.getName());

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.CDI);
    }

    @BuildStep
    AdditionalBeanBuildItem quarkusApplication(CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> quarkusApplications = new ArrayList<String>();
        for (ClassInfo quarkusApplication : combinedIndex.getIndex().getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName()))) {
            if (quarkusApplication.declaredAnnotation(DotNames.DECORATOR) != null) continue;
            quarkusApplications.add(quarkusApplication.name().toString());
        }
        return AdditionalBeanBuildItem.builder().setUnremovable().setDefaultScope(DotName.createSimple((String)ApplicationScoped.class.getName())).addBeanClasses(quarkusApplications).build();
    }

    @BuildStep
    StereotypeRegistrarBuildItem convertLegacyAdditionalStereotypes(final List<AdditionalStereotypeBuildItem> buildItems) {
        return new StereotypeRegistrarBuildItem(new StereotypeRegistrar(){

            public Set<DotName> getAdditionalStereotypes() {
                HashSet<DotName> result = new HashSet<DotName>();
                for (AdditionalStereotypeBuildItem buildItem : buildItems) {
                    result.addAll(buildItem.getStereotypes().values().stream().flatMap(Collection::stream).map(AnnotationInstance::name).collect(Collectors.toSet()));
                }
                return result;
            }
        });
    }

    @BuildStep
    public ContextRegistrationPhaseBuildItem initialize(ArcConfig arcConfig, BeanArchiveIndexBuildItem beanArchiveIndex, CombinedIndexBuildItem combinedIndex, ApplicationIndexBuildItem applicationIndex, List<ExcludedTypeBuildItem> excludedTypes, List<AnnotationsTransformerBuildItem> annotationTransformers, List<InjectionPointTransformerBuildItem> injectionPointTransformers, List<ObserverTransformerBuildItem> observerTransformers, List<InterceptorBindingRegistrarBuildItem> interceptorBindingRegistrars, List<QualifierRegistrarBuildItem> qualifierRegistrars, List<StereotypeRegistrarBuildItem> stereotypeRegistrars, List<ApplicationClassPredicateBuildItem> applicationClassPredicates, List<AdditionalBeanBuildItem> additionalBeans, List<ResourceAnnotationBuildItem> resourceAnnotations, List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations, List<SuppressConditionGeneratorBuildItem> suppressConditionGenerators, final Optional<TestClassPredicateBuildItem> testClassPredicate, Capabilities capabilities, final CustomScopeAnnotationsBuildItem customScopes, LaunchModeBuildItem launchModeBuildItem, BuildProducer<CompletedApplicationClassPredicateBuildItem> applicationClassPredicateProducer) {
        if (!arcConfig.isRemoveUnusedBeansFieldValid()) {
            throw new IllegalArgumentException("Invalid configuration value set for 'quarkus.arc.remove-unused-beans'. Please use one of " + ArcConfig.ALLOWED_REMOVE_UNUSED_BEANS_VALUES);
        }
        final HashMap<String, DotName> additionalBeanTypes = new HashMap<String, DotName>();
        for (AdditionalBeanBuildItem additionalBean : additionalBeans) {
            DotName defaultScope = additionalBean.getDefaultScope();
            for (String beanClass : additionalBean.getBeanClasses()) {
                DotName existingDefaultScope = (DotName)additionalBeanTypes.get(beanClass);
                if (existingDefaultScope != null && defaultScope != null && !existingDefaultScope.equals((Object)defaultScope)) {
                    throw new IllegalStateException("Different default scopes defined for additional bean class: " + beanClass + "\n\t - scopes: " + defaultScope + " and " + existingDefaultScope);
                }
                additionalBeanTypes.put(beanClass, defaultScope);
            }
        }
        Set<DotName> generatedClassNames = beanArchiveIndex.getGeneratedClassNames();
        IndexView index = beanArchiveIndex.getIndex();
        BeanProcessor.Builder builder = BeanProcessor.builder();
        Index applicationClassesIndex = applicationIndex.getIndex();
        AbstractCompositeApplicationClassesPredicate<DotName> applicationClassPredicate = new AbstractCompositeApplicationClassesPredicate<DotName>((IndexView)applicationClassesIndex, generatedClassNames, applicationClassPredicates, testClassPredicate){

            @Override
            protected DotName getDotName(DotName dotName) {
                return dotName;
            }
        };
        applicationClassPredicateProducer.produce((BuildItem)new CompletedApplicationClassPredicateBuildItem((Predicate<DotName>)applicationClassPredicate));
        builder.setApplicationClassPredicate((Predicate)applicationClassPredicate);
        builder.addAnnotationTransformer(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return AnnotationTarget.Kind.CLASS == kind;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo beanClass = transformationContext.getTarget().asClass();
                String beanClassName = beanClass.name().toString();
                if (!additionalBeanTypes.containsKey(beanClassName)) {
                    return;
                }
                if (customScopes.isScopeDeclaredOn(beanClass)) {
                    return;
                }
                DotName defaultScope = (DotName)additionalBeanTypes.get(beanClassName);
                if (defaultScope != null) {
                    ((Transformation)transformationContext.transform().add(defaultScope, new AnnotationValue[0])).done();
                } else if (!beanClass.annotationsMap().containsKey(ADDITIONAL_BEAN)) {
                    ((Transformation)transformationContext.transform().add(ADDITIONAL_BEAN, new AnnotationValue[0])).done();
                }
            }
        });
        builder.setBeanArchiveIndex(index);
        builder.setApplicationIndex(combinedIndex.getIndex());
        List beanDefiningAnnotations = additionalBeanDefiningAnnotations.stream().map(s -> new BeanDefiningAnnotation(s.getName(), s.getDefaultScope())).collect(Collectors.toList());
        beanDefiningAnnotations.add(new BeanDefiningAnnotation(ADDITIONAL_BEAN, null));
        builder.setAdditionalBeanDefiningAnnotations(beanDefiningAnnotations);
        builder.addResourceAnnotations((Collection)resourceAnnotations.stream().map(ResourceAnnotationBuildItem::getName).collect(Collectors.toList()));
        for (AnnotationsTransformerBuildItem annotationsTransformerBuildItem : annotationTransformers) {
            builder.addAnnotationTransformer(annotationsTransformerBuildItem.getAnnotationsTransformer());
        }
        for (InjectionPointTransformerBuildItem injectionPointTransformerBuildItem : injectionPointTransformers) {
            builder.addInjectionPointTransformer(injectionPointTransformerBuildItem.getInjectionPointsTransformer());
        }
        for (ObserverTransformerBuildItem observerTransformerBuildItem : observerTransformers) {
            builder.addObserverTransformer(observerTransformerBuildItem.getInstance());
        }
        for (InterceptorBindingRegistrarBuildItem interceptorBindingRegistrarBuildItem : interceptorBindingRegistrars) {
            builder.addInterceptorBindingRegistrar(interceptorBindingRegistrarBuildItem.getInterceptorBindingRegistrar());
        }
        for (QualifierRegistrarBuildItem qualifierRegistrarBuildItem : qualifierRegistrars) {
            builder.addQualifierRegistrar(qualifierRegistrarBuildItem.getQualifierRegistrar());
        }
        for (StereotypeRegistrarBuildItem stereotypeRegistrarBuildItem : stereotypeRegistrars) {
            builder.addStereotypeRegistrar(stereotypeRegistrarBuildItem.getStereotypeRegistrar());
        }
        builder.setRemoveUnusedBeans(arcConfig.shouldEnableBeanRemoval());
        if (arcConfig.shouldOnlyKeepAppBeans()) {
            builder.addRemovalExclusion((Predicate)new AbstractCompositeApplicationClassesPredicate<BeanInfo>((IndexView)applicationClassesIndex, generatedClassNames, applicationClassPredicates, testClassPredicate){

                @Override
                protected DotName getDotName(BeanInfo bean) {
                    return bean.getBeanClass();
                }
            });
        }
        builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DotName.createSimple((String)TestApplicationClassPredicate.class.getName())));
        for (AdditionalBeanBuildItem additionalBeanBuildItem : additionalBeans) {
            if (additionalBeanBuildItem.isRemovable()) continue;
            for (String beanClass : additionalBeanBuildItem.getBeanClasses()) {
                builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(beanClass));
            }
        }
        for (BeanDefiningAnnotationBuildItem beanDefiningAnnotationBuildItem : additionalBeanDefiningAnnotations) {
            if (beanDefiningAnnotationBuildItem.isRemovable()) continue;
            builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(beanDefiningAnnotationBuildItem.getName()));
        }
        if (arcConfig.unremovableTypes.isPresent()) {
            final List<Predicate<ClassInfo>> classPredicates = this.initClassPredicates(arcConfig.unremovableTypes.get());
            builder.addRemovalExclusion((Predicate)new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo beanInfo) {
                    ClassInfo beanClass = beanInfo.getImplClazz();
                    if (beanClass != null) {
                        for (Predicate predicate : classPredicates) {
                            if (!predicate.test(beanClass)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        if (testClassPredicate.isPresent()) {
            builder.addRemovalExclusion((Predicate)new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo bean) {
                    return ((TestClassPredicateBuildItem)testClassPredicate.get()).getPredicate().test(bean.getBeanClass().toString());
                }
            });
        }
        builder.setTransformUnproxyableClasses(arcConfig.transformUnproxyableClasses);
        builder.setFailOnInterceptedPrivateMethod(arcConfig.failOnInterceptedPrivateMethod);
        builder.setJtaCapabilities(capabilities.isPresent("io.quarkus.transactions"));
        builder.setGenerateSources(BootstrapDebug.DEBUG_SOURCES_DIR != null);
        builder.setAllowMocking(launchModeBuildItem.getLaunchMode() == LaunchMode.TEST);
        if (arcConfig.selectedAlternatives.isPresent()) {
            Iterator<Predicate<ClassInfo>> selectedAlternatives = this.initClassPredicates(arcConfig.selectedAlternatives.get());
            builder.setAlternativePriorities(new AlternativePriorities((List)((Object)selectedAlternatives)){
                final /* synthetic */ List val$selectedAlternatives;
                {
                    this.val$selectedAlternatives = list;
                }

                public Integer compute(AnnotationTarget target, Collection<StereotypeInfo> stereotypes) {
                    ClassInfo clazz;
                    switch (target.kind()) {
                        case CLASS: {
                            clazz = target.asClass();
                            break;
                        }
                        case FIELD: {
                            clazz = target.asField().declaringClass();
                            break;
                        }
                        case METHOD: {
                            clazz = target.asMethod().declaringClass();
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    if (this.val$selectedAlternatives.stream().anyMatch(p -> p.test(clazz))) {
                        return Integer.MAX_VALUE;
                    }
                    if (!stereotypes.isEmpty()) {
                        for (StereotypeInfo stereotype : stereotypes) {
                            if (!this.val$selectedAlternatives.stream().anyMatch(p -> p.test(stereotype.getTarget()))) continue;
                            return Integer.MAX_VALUE;
                        }
                    }
                    return null;
                }
            });
        }
        if (arcConfig.excludeTypes.isPresent()) {
            for (Predicate<ClassInfo> predicate : this.initClassPredicates(arcConfig.excludeTypes.get())) {
                builder.addExcludeType(predicate);
            }
        }
        if (!excludedTypes.isEmpty()) {
            for (Predicate<ClassInfo> predicate : this.initClassPredicates(excludedTypes.stream().map(ExcludedTypeBuildItem::getMatch).collect(Collectors.toList()))) {
                builder.addExcludeType(predicate);
            }
        }
        for (SuppressConditionGeneratorBuildItem suppressConditionGeneratorBuildItem : suppressConditionGenerators) {
            builder.addSuppressConditionGenerator(suppressConditionGeneratorBuildItem.getGenerator());
        }
        BeanProcessor beanProcessor = builder.build();
        ContextRegistrar.RegistrationContext registrationContext = beanProcessor.registerCustomContexts();
        return new ContextRegistrationPhaseBuildItem(registrationContext, beanProcessor);
    }

    @BuildStep
    public BeanRegistrationPhaseBuildItem registerBeans(ContextRegistrationPhaseBuildItem contextRegistrationPhase, List<ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem> contextConfigurationRegistry, BuildProducer<InterceptorResolverBuildItem> interceptorResolver, BuildProducer<BeanDiscoveryFinishedBuildItem> beanDiscoveryFinished, BuildProducer<TransformedAnnotationsBuildItem> transformedAnnotations) {
        for (ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem contextConfigurator : contextConfigurationRegistry) {
            for (ContextConfigurator value : contextConfigurator.getValues()) {
                value.done();
            }
        }
        BeanProcessor beanProcessor = contextRegistrationPhase.getBeanProcessor();
        beanProcessor.registerScopes();
        BeanRegistrar.RegistrationContext registrationContext = beanProcessor.registerBeans();
        BeanDeployment beanDeployment = beanProcessor.getBeanDeployment();
        interceptorResolver.produce((BuildItem)new InterceptorResolverBuildItem(beanDeployment));
        beanDiscoveryFinished.produce((BuildItem)new BeanDiscoveryFinishedBuildItem(beanDeployment));
        transformedAnnotations.produce((BuildItem)new TransformedAnnotationsBuildItem(beanDeployment));
        return new BeanRegistrationPhaseBuildItem(registrationContext, beanProcessor);
    }

    @BuildStep
    public ObserverRegistrationPhaseBuildItem registerSyntheticObservers(BeanRegistrationPhaseBuildItem beanRegistrationPhase, List<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurators, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem beanConfiguratorBuildItem : beanConfigurators) {
            beanConfiguratorBuildItem.getValues().forEach(BeanConfigurator::done);
        }
        beanRegistrationPhase.getBeanProcessor().getBeanDeployment().initBeanByTypeMap();
        List<InjectionPointInfo> listAll = beanRegistrationPhase.getInjectionPoints().stream().filter(this::isListAllInjectionPoint).collect(Collectors.toList());
        for (InjectionPointInfo injectionPoint : listAll) {
            Type typeParam = (Type)injectionPoint.getType().asParameterizedType().arguments().get(0);
            if (typeParam.kind() == Type.Kind.WILDCARD_TYPE) {
                ClassInfo declaringClass = injectionPoint.isField() ? injectionPoint.getTarget().asField().declaringClass() : injectionPoint.getTarget().asMethod().declaringClass();
                if (declaringClass.declaredAnnotation(DotNames.KOTLIN_METADATA_ANNOTATION) != null) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DefinitionException("kotlin.collections.List cannot be used together with the @All qualifier, please use MutableList or java.util.List instead: " + injectionPoint.getTargetInfo())}));
                    continue;
                }
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DefinitionException("Wildcard is not a legal type argument for " + injectionPoint.getTargetInfo())}));
                continue;
            }
            if (typeParam.kind() != Type.Kind.TYPE_VARIABLE) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DefinitionException("Type variable is not a legal type argument for " + injectionPoint.getTargetInfo())}));
        }
        if (!listAll.isEmpty()) {
            this.registerListInjectionPointsBeans(beanRegistrationPhase, listAll, reflectiveMethods, reflectiveFields, unremovableBeans);
        }
        BeanProcessor beanProcessor = beanRegistrationPhase.getBeanProcessor();
        ObserverRegistrar.RegistrationContext registrationContext = beanProcessor.registerSyntheticObservers();
        return new ObserverRegistrationPhaseBuildItem(registrationContext, beanProcessor);
    }

    @BuildStep
    public ValidationPhaseBuildItem validate(ObserverRegistrationPhaseBuildItem observerRegistrationPhase, List<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerConfigurationRegistry, List<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer, BuildProducer<SynthesisFinishedBuildItem> synthesisFinished) {
        for (ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem configurator : observerConfigurationRegistry) {
            configurator.getValues().forEach(ObserverConfigurator::done);
        }
        BeanProcessor beanProcessor = observerRegistrationPhase.getBeanProcessor();
        synthesisFinished.produce((BuildItem)new SynthesisFinishedBuildItem(beanProcessor.getBeanDeployment()));
        BytecodeTransformerConsumer bytecodeTransformerConsumer = new BytecodeTransformerConsumer(bytecodeTransformer);
        beanProcessor.initialize((Consumer)bytecodeTransformerConsumer, unremovableBeans.stream().map(UnremovableBeanBuildItem::getPredicate).collect(Collectors.toList()));
        BeanDeploymentValidator.ValidationContext validationContext = beanProcessor.validate((Consumer)bytecodeTransformerConsumer);
        return new ValidationPhaseBuildItem(validationContext, beanProcessor);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public PreBeanContainerBuildItem generateResources(ArcConfig config, ArcRecorder recorder, ShutdownContextBuildItem shutdown, ValidationPhaseBuildItem validationPhase, List<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, List<BeanContainerListenerBuildItem> beanContainerListenerBuildItems, final BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, final BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, final BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<GeneratedClassBuildItem> generatedClass, LiveReloadBuildItem liveReloadBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResource, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer, List<ReflectiveBeanClassBuildItem> reflectiveBeanClasses, Optional<CurrentContextFactoryBuildItem> currentContextFactory, ExecutorService buildExecutor) throws Exception {
        for (ValidationPhaseBuildItem.ValidationErrorBuildItem validationError : validationErrors) {
            for (Throwable error : validationError.getValues()) {
                validationPhase.getContext().addDeploymentProblem(error);
            }
        }
        BeanProcessor beanProcessor = validationPhase.getBeanProcessor();
        beanProcessor.processValidationErrors(validationPhase.getContext());
        ExistingClasses existingClasses = (ExistingClasses)liveReloadBuildItem.getContextObject(ExistingClasses.class);
        if (existingClasses == null) {
            existingClasses = new ExistingClasses();
            liveReloadBuildItem.setContextObject(ExistingClasses.class, (Object)existingClasses);
        }
        BytecodeTransformerConsumer bytecodeTransformerConsumer = new BytecodeTransformerConsumer(bytecodeTransformer);
        final Set reflectiveBeanClassesNames = reflectiveBeanClasses.stream().map(ReflectiveBeanClassBuildItem::getClassName).collect(Collectors.toSet());
        boolean parallelResourceGeneration = Boolean.parseBoolean(System.getProperty("quarkus.arc.parallel-resource-generation", "true"));
        long start = System.nanoTime();
        ExecutorService executor = parallelResourceGeneration ? buildExecutor : null;
        List resources = beanProcessor.generateResources(new ReflectionRegistration(){

            public void registerMethod(MethodInfo methodInfo) {
                reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(methodInfo));
            }

            public void registerField(FieldInfo fieldInfo) {
                reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(fieldInfo));
            }

            public void registerClientProxy(DotName beanClassName, String clientProxyName) {
                if (reflectiveBeanClassesNames.contains(beanClassName)) {
                    reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{clientProxyName}));
                }
            }

            public void registerSubclass(DotName beanClassName, String subclassName) {
                if (reflectiveBeanClassesNames.contains(beanClassName)) {
                    reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{subclassName}));
                }
            }
        }, existingClasses.existingClasses, (Consumer)bytecodeTransformerConsumer, config.shouldEnableBeanRemoval() && config.detectUnusedFalsePositives, executor);
        for (ResourceOutput.Resource resource : resources) {
            switch (resource.getType()) {
                case JAVA_CLASS: {
                    LOGGER.debugf("Add %s class: %s", (Object)(resource.isApplicationClass() ? "APP" : "FWK"), (Object)resource.getFullyQualifiedName());
                    generatedClass.produce((BuildItem)new GeneratedClassBuildItem(resource.isApplicationClass(), resource.getName(), resource.getData(), resource.getSource()));
                    if (resource.isApplicationClass()) break;
                    existingClasses.existingClasses.add(resource.getName());
                    break;
                }
                case SERVICE_PROVIDER: {
                    generatedResource.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/services/" + resource.getName(), resource.getData()));
                    break;
                }
            }
        }
        LOGGER.debugf("Generated %s resources in %s ms", (long)resources.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        for (ClassInfo qualifier : beanProcessor.getBeanDeployment().getQualifiers()) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{qualifier.name().toString()}));
        }
        for (ClassInfo binding : beanProcessor.getBeanDeployment().getInterceptorBindings()) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{binding.name().toString()}));
        }
        ArcContainer container = recorder.initContainer((ShutdownContext)shutdown, currentContextFactory.isPresent() ? currentContextFactory.get().getFactory() : null);
        BeanContainer beanContainer = recorder.initBeanContainer(container, beanContainerListenerBuildItems.stream().map(BeanContainerListenerBuildItem::getBeanContainerListener).collect(Collectors.toList()));
        return new PreBeanContainerBuildItem(beanContainer);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void signalBeanContainerReady(AppCDSRecorder recorder, PreBeanContainerBuildItem bi, Optional<AppCDSRequestedBuildItem> appCDSRequested, BuildProducer<AppCDSControlPointBuildItem> appCDSControlPointProducer, BuildProducer<BeanContainerBuildItem> beanContainerProducer) {
        if (appCDSRequested.isPresent()) {
            recorder.controlGenerationAndExit();
            appCDSControlPointProducer.produce((BuildItem)new AppCDSControlPointBuildItem());
        }
        beanContainerProducer.produce((BuildItem)new BeanContainerBuildItem(bi.getValue()));
    }

    @BuildStep(onlyIf={IsTest.class})
    public AdditionalBeanBuildItem testApplicationClassPredicateBean() {
        return AdditionalBeanBuildItem.unremovableOf(PreloadedTestApplicationClassPredicate.class);
    }

    @BuildStep(onlyIf={IsTest.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void initTestApplicationClassPredicateBean(ArcRecorder recorder, BeanContainerBuildItem beanContainer, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, CompletedApplicationClassPredicateBuildItem predicate) {
        HashSet<String> applicationBeanClasses = new HashSet<String>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            if (!predicate.test(bean.getBeanClass())) continue;
            applicationBeanClasses.add(bean.getBeanClass().toString());
        }
        recorder.initTestApplicationClassPredicate(applicationBeanClasses);
    }

    @BuildStep
    List<AdditionalApplicationArchiveMarkerBuildItem> marker() {
        return Arrays.asList(new AdditionalApplicationArchiveMarkerBuildItem("META-INF/beans.xml"), new AdditionalApplicationArchiveMarkerBuildItem("META-INF/services/javax.enterprise.inject.spi.Extension"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupExecutor(ExecutorBuildItem executor, ArcRecorder recorder) {
        recorder.initExecutor(executor.getExecutorProxy());
    }

    @BuildStep
    AdditionalBeanBuildItem launchMode() {
        return new AdditionalBeanBuildItem(LaunchModeProducer.class);
    }

    @BuildStep
    AdditionalBeanBuildItem loggerProducer() {
        return new AdditionalBeanBuildItem(LoggerProducer.class);
    }

    @BuildStep
    CustomScopeAnnotationsBuildItem exposeCustomScopeNames(List<CustomScopeBuildItem> customScopes) {
        HashSet<DotName> names = new HashSet<DotName>();
        for (CustomScopeBuildItem customScope : customScopes) {
            names.add(customScope.getAnnotationName());
        }
        return new CustomScopeAnnotationsBuildItem(names);
    }

    private List<Predicate<ClassInfo>> initClassPredicates(List<String> types) {
        String packMatch = ".*";
        String packStarts = ".**";
        ArrayList<Predicate<ClassInfo>> predicates = new ArrayList<Predicate<ClassInfo>>();
        for (final String val : types) {
            if (val.endsWith(".*")) {
                final String pack = val.substring(0, val.length() - ".*".length());
                predicates.add(new Predicate<ClassInfo>(){

                    @Override
                    public boolean test(ClassInfo c) {
                        return DotNames.packageName((DotName)c.name()).equals(pack);
                    }
                });
                continue;
            }
            if (val.endsWith(".**")) {
                final String prefix = val.substring(0, val.length() - ".**".length());
                predicates.add(new Predicate<ClassInfo>(){

                    @Override
                    public boolean test(ClassInfo c) {
                        return DotNames.packageName((DotName)c.name()).startsWith(prefix);
                    }
                });
                continue;
            }
            if (val.contains(".")) {
                predicates.add(new Predicate<ClassInfo>(){

                    @Override
                    public boolean test(ClassInfo c) {
                        return c.name().toString().equals(val);
                    }
                });
                continue;
            }
            predicates.add(new Predicate<ClassInfo>(){

                @Override
                public boolean test(ClassInfo c) {
                    return DotNames.simpleName((ClassInfo)c).equals(val);
                }
            });
        }
        return predicates;
    }

    @BuildStep
    BeanDefiningAnnotationBuildItem quarkusMain() {
        return new BeanDefiningAnnotationBuildItem(DotName.createSimple((String)QuarkusMain.class.getName()), DotNames.SINGLETON);
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformListAllInjectionPoints() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public int getPriority() {
                return Integer.MIN_VALUE;
            }

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD || kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (Annotations.contains((Collection)ctx.getAnnotations(), (DotName)DotNames.ALL)) {
                    AnnotationTarget target = ctx.getTarget();
                    if (target.kind() == AnnotationTarget.Kind.FIELD) {
                        String id = HashUtil.sha1((String)(target.asField().type().toString() + target.asField().annotations().toString()));
                        ((Transformation)ctx.transform().add(DotNames.IDENTIFIED, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)id)})).done();
                    } else {
                        MethodInfo method = target.asMethod();
                        Set alls = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD_PARAMETER, (DotName)DotNames.ALL, (Collection)ctx.getAnnotations());
                        Set paramsAnnotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD_PARAMETER, (Collection)ctx.getAnnotations());
                        ArrayList<AnnotationInstance> toAdd = new ArrayList<AnnotationInstance>();
                        for (AnnotationInstance annotation : alls) {
                            short position = annotation.target().asMethodParameter().position();
                            HashSet<AnnotationInstance> paramAnnotations = new HashSet<AnnotationInstance>();
                            for (AnnotationInstance paramAnnotation : paramsAnnotations) {
                                if (paramAnnotation.target().asMethodParameter().position() != position) continue;
                                paramAnnotations.add(paramAnnotation);
                            }
                            String id = HashUtil.sha1((String)(method.parameterType((int)position) + ((Object)paramAnnotations).toString()));
                            toAdd.add(AnnotationInstance.create((DotName)DotNames.IDENTIFIED, (AnnotationTarget)MethodParameterInfo.create((MethodInfo)method, (short)annotation.target().asMethodParameter().position()), (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)id)}));
                        }
                        Transformation transform = ctx.transform();
                        toAdd.forEach(x$0 -> {
                            Transformation cfr_ignored_0 = (Transformation)transform.add(x$0);
                        });
                        transform.done();
                    }
                }
            }
        });
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableAsyncObserverExceptionHandlers() {
        return UnremovableBeanBuildItem.beanTypes(Set.of(ASYNC_OBSERVER_EXCEPTION_HANDLER));
    }

    @BuildStep
    void validateAsyncObserverExceptionHandlers(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        BeanResolver resolver = validationPhase.getBeanProcessor().getBeanDeployment().getBeanResolver();
        try {
            BeanInfo bean = resolver.resolveAmbiguity(resolver.resolveBeans(Type.create((DotName)ASYNC_OBSERVER_EXCEPTION_HANDLER, (Type.Kind)Type.Kind.CLASS), new AnnotationInstance[0]));
            if (bean == null) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new UnsatisfiedResolutionException("AsyncObserverExceptionHandler bean not found")}));
            }
        }
        catch (AmbiguousResolutionException e) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(e));
        }
    }

    @BuildStep
    void registerContextPropagation(ArcConfig config, BuildProducer<ThreadContextProviderBuildItem> threadContextProvider) {
        if (config.contextPropagation.enabled) {
            threadContextProvider.produce((BuildItem)new ThreadContextProviderBuildItem(ArcContextProvider.class));
        }
    }

    private void registerListInjectionPointsBeans(BeanRegistrationPhaseBuildItem beanRegistrationPhase, List<InjectionPointInfo> injectionPoints, final BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, final BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        BeanDeployment beanDeployment = beanRegistrationPhase.getBeanProcessor().getBeanDeployment();
        AnnotationLiteralProcessor annotationLiterals = beanRegistrationPhase.getBeanProcessor().getAnnotationLiteralProcessor();
        ReflectionRegistration reflectionRegistration = new ReflectionRegistration(){

            public void registerMethod(MethodInfo methodInfo) {
                reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(methodInfo));
            }

            public void registerField(FieldInfo fieldInfo) {
                reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(fieldInfo));
            }
        };
        final ArrayList<InjectionPointInfo.TypeAndQualifiers> unremovables = new ArrayList<InjectionPointInfo.TypeAndQualifiers>();
        HashSet<String> ids = new HashSet<String>();
        for (InjectionPointInfo injectionPoint : injectionPoints) {
            Type elementType;
            AnnotationInstance identifiedAnnotation;
            if (injectionPoint.isField()) {
                reflectionRegistration.registerField(injectionPoint.getTarget().asField());
            } else {
                reflectionRegistration.registerMethod(injectionPoint.getTarget().asMethod());
            }
            if ((identifiedAnnotation = injectionPoint.getRequiredQualifier(DotNames.IDENTIFIED)) == null || !ids.add(identifiedAnnotation.value().asString())) continue;
            HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>(injectionPoint.getRequiredQualifiers());
            Iterator it = qualifiers.iterator();
            while (it.hasNext()) {
                AnnotationInstance qualifier = (AnnotationInstance)it.next();
                if (!DotNames.ALL.equals((Object)qualifier.name()) && !DotNames.IDENTIFIED.equals((Object)qualifier.name())) continue;
                it.remove();
            }
            if (qualifiers.isEmpty()) {
                qualifiers.add(AnnotationInstance.create((DotName)DotNames.ANY, null, (AnnotationValue[])new AnnotationValue[0]));
            }
            unremovables.add(new InjectionPointInfo.TypeAndQualifiers((elementType = (Type)injectionPoint.getType().asParameterizedType().arguments().get(0)).name().equals((Object)DotNames.INSTANCE_HANDLE) ? (Type)elementType.asParameterizedType().arguments().get(0) : elementType, qualifiers));
            BeanConfigurator configurator = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistrationPhase.getContext().configure(List.class).forceApplicationClass()).scope(BuiltinScope.DEPENDENT.getInfo())).addType(injectionPoint.getRequiredType());
            injectionPoint.getRequiredQualifiers().forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
            if (injectionPoint.getTargetBean().isPresent()) {
                configurator.targetPackageName(((BeanInfo)injectionPoint.getTargetBean().get()).getTargetPackageName());
            }
            configurator.creator(mc -> {
                MethodDescriptor instancesMethod;
                ResultHandle requiredType;
                ResultHandle injectionPointType = Types.getTypeHandle((BytecodeCreator)mc, (Type)injectionPoint.getType());
                if (elementType.name().equals((Object)DotNames.INSTANCE_HANDLE)) {
                    requiredType = Types.getTypeHandle((BytecodeCreator)mc, (Type)((Type)elementType.asParameterizedType().arguments().get(0)));
                    instancesMethod = MethodDescriptors.INSTANCES_LIST_OF_HANDLES;
                } else {
                    requiredType = Types.getTypeHandle((BytecodeCreator)mc, (Type)elementType);
                    instancesMethod = MethodDescriptors.INSTANCES_LIST_OF;
                }
                ResultHandle requiredQualifiers = BeanGenerator.collectQualifiers(null, null, (BeanDeployment)beanDeployment, (MethodCreator)mc, (AnnotationLiteralProcessor)annotationLiterals, (Set)qualifiers);
                ResultHandle injectionPointAnnotations = BeanGenerator.collectInjectionPointAnnotations(null, null, (BeanDeployment)beanDeployment, (MethodCreator)mc, (InjectionPointInfo)injectionPoint, (AnnotationLiteralProcessor)annotationLiterals, (Predicate)beanRegistrationPhase.getBeanProcessor().getInjectionPointAnnotationsPredicate());
                ResultHandle javaMember = BeanGenerator.getJavaMemberHandle((MethodCreator)mc, (InjectionPointInfo)injectionPoint, (ReflectionRegistration)ReflectionRegistration.NOOP);
                ResultHandle container = mc.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
                ResultHandle targetBean = mc.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_BEAN, container, new ResultHandle[]{injectionPoint.getTargetBean().isPresent() ? mc.load(((BeanInfo)injectionPoint.getTargetBean().get()).getIdentifier()) : mc.loadNull()});
                ResultHandle ret = mc.invokeStaticMethod(instancesMethod, new ResultHandle[]{targetBean, injectionPointType, requiredType, requiredQualifiers, mc.getMethodParam(0), injectionPointAnnotations, javaMember, mc.load(injectionPoint.getPosition())});
                mc.returnValue(ret);
            });
            configurator.done();
        }
        if (!unremovables.isEmpty()) {
            beanDeployment.initBeanByTypeMap();
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo bean) {
                    for (InjectionPointInfo.TypeAndQualifiers tq : unremovables) {
                        if (!Beans.matches((BeanInfo)bean, (InjectionPointInfo.TypeAndQualifiers)tq)) continue;
                        return true;
                    }
                    return false;
                }
            }));
        }
    }

    private boolean isListAllInjectionPoint(InjectionPointInfo injectionPoint) {
        return DotNames.LIST.equals((Object)injectionPoint.getRequiredType().name()) && Annotations.contains((Collection)injectionPoint.getRequiredQualifiers(), (DotName)DotNames.ALL);
    }

    private static class BytecodeTransformerConsumer
    implements Consumer<BytecodeTransformer> {
        private final BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer;

        public BytecodeTransformerConsumer(BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer) {
            this.bytecodeTransformer = bytecodeTransformer;
        }

        @Override
        public void accept(BytecodeTransformer t) {
            this.bytecodeTransformer.produce((BuildItem)new BytecodeTransformerBuildItem(t.getClassToTransform(), t.getVisitorFunction()));
        }
    }

    static class ExistingClasses {
        Set<String> existingClasses = new HashSet<String>();

        ExistingClasses() {
        }
    }

    private static abstract class AbstractCompositeApplicationClassesPredicate<T>
    implements Predicate<T> {
        private final IndexView applicationClassesIndex;
        private final Set<DotName> generatedClassNames;
        private final List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems;
        private final Optional<TestClassPredicateBuildItem> testClassPredicate;

        protected abstract DotName getDotName(T var1);

        private AbstractCompositeApplicationClassesPredicate(IndexView applicationClassesIndex, Set<DotName> generatedClassNames, List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems, Optional<TestClassPredicateBuildItem> testClassPredicate) {
            this.applicationClassesIndex = applicationClassesIndex;
            this.generatedClassNames = generatedClassNames;
            this.applicationClassPredicateBuildItems = applicationClassPredicateBuildItems;
            this.testClassPredicate = testClassPredicate;
        }

        @Override
        public boolean test(T t) {
            DotName dotName = this.getDotName(t);
            if (this.applicationClassesIndex.getClassByName(dotName) != null) {
                return true;
            }
            if (this.generatedClassNames.contains(dotName)) {
                return true;
            }
            String className = dotName.toString();
            if (!this.applicationClassPredicateBuildItems.isEmpty()) {
                for (ApplicationClassPredicateBuildItem predicate : this.applicationClassPredicateBuildItems) {
                    if (!predicate.test(className)) continue;
                    return true;
                }
            }
            return this.testClassPredicate.isPresent() && this.testClassPredicate.get().getPredicate().test(className);
        }
    }
}

