/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanArchivePredicateBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BuildCompatibleExtensionsBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ExcludeDependencyBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.index.PersistentClassIndex;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class BeanArchiveProcessor {
    private static final Logger LOGGER = Logger.getLogger(BeanArchiveProcessor.class);

    /*
     * WARNING - void declaration
     */
    @BuildStep
    public BeanArchiveIndexBuildItem build(ArcConfig config, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations, List<AdditionalBeanBuildItem> additionalBeans, List<GeneratedBeanBuildItem> generatedBeans, LiveReloadBuildItem liveReloadBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, CustomScopeAnnotationsBuildItem customScopes, List<ExcludeDependencyBuildItem> excludeDependencyBuildItems, List<BeanArchivePredicateBuildItem> beanArchivePredicates, BuildCompatibleExtensionsBuildItem buildCompatibleExtensions) throws Exception {
        void var19_23;
        IndexView applicationIndex = this.buildApplicationIndex(config, applicationArchivesBuildItem, additionalBeanDefiningAnnotations, customScopes, excludeDependencyBuildItems, beanArchivePredicates);
        Indexer additionalBeanIndexer = new Indexer();
        ArrayList<String> additionalBeanClasses = new ArrayList<String>();
        for (AdditionalBeanBuildItem i : additionalBeans) {
            additionalBeanClasses.addAll(i.getBeanClasses());
        }
        HashSet additionalBeansFromExtensions = new HashSet();
        buildCompatibleExtensions.entrypoint.runDiscovery(applicationIndex, additionalBeansFromExtensions);
        additionalBeanClasses.addAll(additionalBeansFromExtensions);
        HashSet additionalIndex = new HashSet();
        HashSet knownMissingClasses = new HashSet();
        for (String string : additionalBeanClasses) {
            IndexingUtil.indexClass((String)string, (Indexer)additionalBeanIndexer, (IndexView)applicationIndex, additionalIndex, knownMissingClasses, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        HashSet<DotName> generatedClassNames = new HashSet<DotName>();
        for (GeneratedBeanBuildItem generatedBeanClass : generatedBeans) {
            IndexingUtil.indexClass((String)generatedBeanClass.getName(), (Indexer)additionalBeanIndexer, (IndexView)applicationIndex, additionalIndex, knownMissingClasses, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])generatedBeanClass.getData());
            generatedClassNames.add(DotName.createSimple((String)generatedBeanClass.getName().replace('/', '.')));
            generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, generatedBeanClass.getName(), generatedBeanClass.getData(), generatedBeanClass.getSource()));
        }
        PersistentClassIndex persistentClassIndex = (PersistentClassIndex)liveReloadBuildItem.getContextObject(PersistentClassIndex.class);
        if (persistentClassIndex == null) {
            PersistentClassIndex persistentClassIndex2 = new PersistentClassIndex();
            liveReloadBuildItem.setContextObject(PersistentClassIndex.class, (Object)persistentClassIndex2);
        }
        Map additionalClasses = var19_23.getAdditionalClasses();
        for (DotName knownMissingClass : knownMissingClasses) {
            additionalClasses.put(knownMissingClass, Optional.empty());
        }
        IndexView immutableBeanArchiveIndex = BeanArchives.buildImmutableBeanArchiveIndex((IndexView[])new IndexView[]{applicationIndex, additionalBeanIndexer.complete()});
        IndexView computingBeanArchiveIndex = BeanArchives.buildComputingBeanArchiveIndex((ClassLoader)Thread.currentThread().getContextClassLoader(), (Map)additionalClasses, (IndexView)immutableBeanArchiveIndex);
        return new BeanArchiveIndexBuildItem(computingBeanArchiveIndex, immutableBeanArchiveIndex, generatedClassNames);
    }

    private IndexView buildApplicationIndex(ArcConfig config, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations, CustomScopeAnnotationsBuildItem customScopes, List<ExcludeDependencyBuildItem> excludeDependencyBuildItems, List<BeanArchivePredicateBuildItem> beanArchivePredicates) {
        Set archives = applicationArchivesBuildItem.getAllApplicationArchives();
        HashSet<DotName> stereotypes = new HashSet<DotName>();
        for (ApplicationArchive archive : archives) {
            Collection annotations = archive.getIndex().getAnnotations(DotNames.STEREOTYPE);
            if (annotations.isEmpty()) continue;
            for (AnnotationInstance annotationInstance : annotations) {
                if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                stereotypes.add(annotationInstance.target().asClass().name());
            }
        }
        Set beanDefiningAnnotations = BeanDeployment.initBeanDefiningAnnotations((Collection)additionalBeanDefiningAnnotations.stream().map(bda -> new BeanDefiningAnnotation(bda.getName(), bda.getDefaultScope())).collect(Collectors.toList()), stereotypes);
        beanDefiningAnnotations.addAll(customScopes.getCustomScopeNames());
        beanDefiningAnnotations.add(DotNames.QUALIFIER);
        beanDefiningAnnotations.add(DotNames.INTERCEPTOR_BINDING);
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getApplicationArchives()) {
            if (this.isApplicationArchiveExcluded(config, excludeDependencyBuildItems, archive) || !this.possiblyBeanArchive(archive)) continue;
            IndexView index = archive.getIndex();
            if (!this.isExplicitBeanArchive(archive) && !this.isImplicitBeanArchive(index, beanDefiningAnnotations) && !this.isAdditionalBeanArchive(archive, beanArchivePredicates)) continue;
            indexes.add(index);
        }
        indexes.add(applicationArchivesBuildItem.getRootArchive().getIndex());
        return CompositeIndex.create(indexes);
    }

    private boolean isExplicitBeanArchive(ApplicationArchive archive) {
        return (Boolean)archive.apply(tree -> tree.contains("META-INF/beans.xml") || tree.contains("WEB-INF/beans.xml"));
    }

    private boolean isImplicitBeanArchive(IndexView index, Set<DotName> beanDefiningAnnotations) {
        return index.getAllKnownImplementors(DotNames.EXTENSION).isEmpty() && index.getAllKnownImplementors(DotNames.BUILD_COMPATIBLE_EXTENSION).isEmpty() && this.containsBeanDefiningAnnotation(index, beanDefiningAnnotations);
    }

    private boolean isAdditionalBeanArchive(ApplicationArchive archive, List<BeanArchivePredicateBuildItem> beanArchivePredicates) {
        for (BeanArchivePredicateBuildItem p : beanArchivePredicates) {
            if (!p.getPredicate().test(archive)) continue;
            return true;
        }
        return false;
    }

    private boolean possiblyBeanArchive(ApplicationArchive archive) {
        return (Boolean)archive.apply(tree -> {
            boolean result = true;
            for (String beansXml : List.of("META-INF/beans.xml", "WEB-INF/beans.xml")) {
                result &= ((Boolean)tree.apply(beansXml, pathVisit -> {
                    if (pathVisit == null) {
                        return true;
                    }
                    try {
                        String text = Files.readString(pathVisit.getPath());
                        if (text.contains("bean-discovery-mode='none'") || text.contains("bean-discovery-mode=\"none\"")) {
                            return false;
                        }
                        if (text.contains("bean-discovery-mode='all'") || text.contains("bean-discovery-mode=\"all\"")) {
                            LOGGER.warnf("Detected bean archive with bean discovery mode of 'all', this is not portable in CDI Lite and is treated as 'annotated' in Quarkus! Path to beans.xml: %s", archive.getKey() != null ? archive.getKey().toGacString() + ":" + pathVisit.getPath() : pathVisit.getPath());
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return true;
                })).booleanValue();
            }
            return result;
        });
    }

    private boolean isApplicationArchiveExcluded(ArcConfig config, List<ExcludeDependencyBuildItem> excludeDependencyBuildItems, ApplicationArchive archive) {
        if (archive.getKey() != null) {
            ArtifactKey key = archive.getKey();
            for (IndexDependencyConfig excludeDependency : config.excludeDependency.values()) {
                if (!BeanArchiveProcessor.archiveMatches(key, excludeDependency.groupId, excludeDependency.artifactId, excludeDependency.classifier)) continue;
                return true;
            }
            for (ExcludeDependencyBuildItem excludeDependencyBuildItem : excludeDependencyBuildItems) {
                if (!BeanArchiveProcessor.archiveMatches(key, excludeDependencyBuildItem.getGroupId(), excludeDependencyBuildItem.getArtifactId(), excludeDependencyBuildItem.getClassifier())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean archiveMatches(ArtifactKey key, String groupId, String artifactId, Optional<String> classifier) {
        if (Objects.equals(key.getArtifactId(), artifactId) && Objects.equals(key.getGroupId(), groupId)) {
            if (classifier.isPresent() && Objects.equals(key.getClassifier(), classifier.get())) {
                return true;
            }
            if (!classifier.isPresent() && "".equals(key.getClassifier())) {
                return true;
            }
        }
        return false;
    }

    boolean containsBeanDefiningAnnotation(IndexView index, Collection<DotName> beanDefiningAnnotations) {
        for (DotName beanDefiningAnnotation : beanDefiningAnnotations) {
            if (index.getAnnotations(beanDefiningAnnotation).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

