/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import io.quarkus.arc.deployment.devconsole.DevBeanInfos;
import io.quarkus.arc.deployment.devconsole.DevDecoratorInfo;
import io.quarkus.arc.deployment.devconsole.DevInterceptorInfo;
import io.quarkus.arc.deployment.devconsole.DevObserverInfo;
import io.quarkus.arc.deployment.devui.ArcBeanInfoBuildItem;
import io.quarkus.arc.deployment.devui.DevBeanWithInterceptorInfo;
import io.quarkus.arc.runtime.devui.ArcJsonRPCService;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.ArrayList;
import java.util.List;

public class ArcDevUIProcessor {
    private static final String NAME = "ArC";
    private static final String BEANS = "beans";
    private static final String OBSERVERS = "observers";
    private static final String INTERCEPTORS = "interceptors";
    private static final String DECORATORS = "decorators";
    private static final String REMOVED_BEANS = "removedBeans";
    private static final String REMOVED_DECORATORS = "removedDecorators";
    private static final String REMOVED_INTERCEPTORS = "removedInterceptors";

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem pages(ArcBeanInfoBuildItem arcBeanInfoBuildItem, ArcConfig config) {
        int removedComponents;
        List<DevDecoratorInfo> decorators;
        List<DevInterceptorInfo> interceptors;
        List<DevObserverInfo> observers;
        DevBeanInfos beanInfos = arcBeanInfoBuildItem.getBeanInfos();
        CardPageBuildItem pageBuildItem = new CardPageBuildItem(NAME);
        List<DevBeanInfo> beans = beanInfos.getBeans();
        if (!beans.isEmpty()) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:egg")).componentLink("qwc-arc-beans.js").staticLabel(String.valueOf(beans.size())));
            pageBuildItem.addBuildTimeData(BEANS, this.toDevBeanWithInterceptorInfo(beans, beanInfos));
        }
        if (!(observers = beanInfos.getObservers()).isEmpty()) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:eye")).componentLink("qwc-arc-observers.js").staticLabel(String.valueOf(observers.size())));
            pageBuildItem.addBuildTimeData(OBSERVERS, observers);
        }
        if (!(interceptors = beanInfos.getInterceptors()).isEmpty()) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:traffic-light")).componentLink("qwc-arc-interceptors.js").staticLabel(String.valueOf(interceptors.size())));
            pageBuildItem.addBuildTimeData(INTERCEPTORS, interceptors);
        }
        if (!(decorators = beanInfos.getDecorators()).isEmpty()) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:traffic-light")).componentLink("qwc-arc-decorators.js").staticLabel(String.valueOf(decorators.size())));
            pageBuildItem.addBuildTimeData(DECORATORS, decorators);
        }
        if (config.devMode.monitoringEnabled) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:fire")).componentLink("qwc-arc-fired-events.js"));
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:diagram-project")).componentLink("qwc-arc-invocation-trees.js"));
        }
        if ((removedComponents = beanInfos.getRemovedComponents()) > 0) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:trash-can")).componentLink("qwc-arc-removed-components.js").staticLabel(String.valueOf(removedComponents)));
            pageBuildItem.addBuildTimeData(REMOVED_BEANS, beanInfos.getRemovedBeans());
            pageBuildItem.addBuildTimeData(REMOVED_DECORATORS, beanInfos.getRemovedDecorators());
            pageBuildItem.addBuildTimeData(REMOVED_INTERCEPTORS, beanInfos.getRemovedInterceptors());
        }
        return pageBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(NAME, ArcJsonRPCService.class);
    }

    private List<DevBeanWithInterceptorInfo> toDevBeanWithInterceptorInfo(List<DevBeanInfo> beans, DevBeanInfos devBeanInfos) {
        ArrayList<DevBeanWithInterceptorInfo> l = new ArrayList<DevBeanWithInterceptorInfo>();
        for (DevBeanInfo dbi : beans) {
            l.add(new DevBeanWithInterceptorInfo(dbi, devBeanInfos));
        }
        return l;
    }
}

