/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.devconsole.DependencyGraph;
import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import io.quarkus.arc.deployment.devconsole.DevDecoratorInfo;
import io.quarkus.arc.deployment.devconsole.DevInterceptorInfo;
import io.quarkus.arc.deployment.devconsole.DevObserverInfo;
import io.quarkus.dev.console.DevConsoleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DevBeanInfos {
    private final List<DevBeanInfo> beans = new ArrayList<DevBeanInfo>();
    private final List<DevBeanInfo> removedBeans = new ArrayList<DevBeanInfo>();
    private final List<DevObserverInfo> observers = new ArrayList<DevObserverInfo>();
    private final List<DevInterceptorInfo> interceptors = new ArrayList<DevInterceptorInfo>();
    private final List<DevInterceptorInfo> removedInterceptors = new ArrayList<DevInterceptorInfo>();
    private final List<DevDecoratorInfo> decorators = new ArrayList<DevDecoratorInfo>();
    private final List<DevDecoratorInfo> removedDecorators = new ArrayList<DevDecoratorInfo>();
    private final Map<String, DependencyGraph> dependencyGraphs = new HashMap<String, DependencyGraph>();

    public List<DevBeanInfo> getRemovedBeans() {
        return this.removedBeans;
    }

    public List<DevBeanInfo> getBeans() {
        return this.beans;
    }

    public List<DevObserverInfo> getObservers() {
        return this.observers;
    }

    public List<DevInterceptorInfo> getInterceptors() {
        return this.interceptors;
    }

    public List<DevDecoratorInfo> getDecorators() {
        return this.decorators;
    }

    public List<DevInterceptorInfo> getRemovedInterceptors() {
        return this.removedInterceptors;
    }

    public List<DevDecoratorInfo> getRemovedDecorators() {
        return this.removedDecorators;
    }

    public Map<String, DependencyGraph> getDependencyGraphs() {
        return this.dependencyGraphs;
    }

    public String getBeanDescription() {
        return (String)DevConsoleManager.getGlobal((String)"io.quarkus.arc.beanDescription");
    }

    public int getMaxDependencyLevel() {
        Integer val = (Integer)DevConsoleManager.getGlobal((String)"io.quarkus.arc.maxDependencyLevel");
        return val != null ? val : 10;
    }

    public DevBeanInfo getBean(String id) {
        for (DevBeanInfo bean : this.beans) {
            if (!bean.getId().equals(id)) continue;
            return bean;
        }
        return null;
    }

    public DevInterceptorInfo getInterceptor(String id) {
        for (DevInterceptorInfo interceptor : this.interceptors) {
            if (!interceptor.getId().equals(id)) continue;
            return interceptor;
        }
        return null;
    }

    public DependencyGraph getDependencyGraph(String beanId) {
        Integer maxLevel = (Integer)DevConsoleManager.getGlobal((String)"io.quarkus.arc.maxDependencyLevel");
        if (maxLevel == null) {
            maxLevel = 10;
        }
        DependencyGraph graph = this.dependencyGraphs.get(beanId);
        return graph.maxLevel <= maxLevel ? graph : graph.forLevel(maxLevel);
    }

    public int getRemovedComponents() {
        return this.removedBeans.size() + this.removedInterceptors.size() + this.removedDecorators.size();
    }

    void addBean(DevBeanInfo beanInfo) {
        this.beans.add(beanInfo);
    }

    void addRemovedBean(DevBeanInfo beanInfo) {
        this.removedBeans.add(beanInfo);
    }

    void addObserver(DevObserverInfo observer) {
        this.observers.add(observer);
    }

    void addInterceptor(DevInterceptorInfo interceptor) {
        this.interceptors.add(interceptor);
    }

    void addRemovedInterceptor(DevInterceptorInfo interceptor) {
        this.removedInterceptors.add(interceptor);
    }

    void addDecorator(DevDecoratorInfo decorator) {
        this.decorators.add(decorator);
    }

    void addRemovedDecorator(DevDecoratorInfo decorator) {
        this.removedDecorators.add(decorator);
    }

    void addDependencyGraph(String beanId, DependencyGraph graph) {
        this.dependencyGraphs.put(beanId, graph);
    }

    void sort() {
        Collections.sort(this.beans);
        Collections.sort(this.removedBeans);
        Collections.sort(this.observers);
        Collections.sort(this.interceptors);
        Collections.sort(this.decorators);
        Collections.sort(this.removedDecorators);
        Collections.sort(this.removedInterceptors);
    }
}

