/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.deployment.test.TestResourceProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Qualifier;

public class ArcTestResourceProvider
implements TestResourceProvider {
    public void inject(Object test) {
        for (Class<?> c = test.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Inject.class)) continue;
                BeanManager beanManager = Arc.container().beanManager();
                ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                    qualifiers.add(a);
                }
                Set beans = beanManager.getBeans(f.getType(), qualifiers.toArray(new Annotation[qualifiers.size()]));
                Bean bean = beanManager.resolve(beans);
                CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
                Object instance = beanManager.getReference(bean, f.getType(), ctx);
                f.setAccessible(true);
                try {
                    f.set(test, instance);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

