/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.deployment.annotations.BuildStep;
import io.smallrye.config.inject.ConfigProducer;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class ConfigBuildStep {
    @BuildStep
    AdditionalBeanBuildItem bean() {
        return new AdditionalBeanBuildItem(ConfigProducer.class.getName());
    }

    @BuildStep
    BeanDeploymentValidatorBuildItem beanDeploymentValidator() {
        return new BeanDeploymentValidatorBuildItem(new ConfigBeanDeploymentValidator());
    }

    static class ConfigBeanDeploymentValidator
    implements BeanDeploymentValidator {
        private static final DotName CONFIG_PROPERTY_NAME = DotName.createSimple((String)ConfigProperty.class.getName());

        ConfigBeanDeploymentValidator() {
        }

        public void validate(BeanDeploymentValidator.ValidationContext validationContext) {
            Config config = ConfigProvider.getConfig();
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            for (InjectionPointInfo injectionPoint : (List)validationContext.get(BuildExtension.Key.INJECTION_POINTS)) {
                AnnotationInstance configProperty;
                if (injectionPoint.hasDefaultedQualifier() || (configProperty = (AnnotationInstance)injectionPoint.getRequiredQualifiers().stream().filter(a -> a.name().equals((Object)CONFIG_PROPERTY_NAME)).findFirst().orElse(null)) == null || DotNames.OPTIONAL.equals((Object)injectionPoint.getRequiredType().name())) continue;
                String key = configProperty.value("name").asString();
                try {
                    AnnotationValue defaultValue;
                    Class<Object> type;
                    block14: {
                        block13: {
                            if (injectionPoint.getRequiredType().kind() != Type.Kind.PRIMITIVE) break block13;
                            switch (injectionPoint.getRequiredType().asPrimitiveType().primitive()) {
                                case BOOLEAN: {
                                    type = Boolean.TYPE;
                                    break block14;
                                }
                                case BYTE: {
                                    type = Byte.TYPE;
                                    break block14;
                                }
                                case CHAR: {
                                    type = Character.TYPE;
                                    break block14;
                                }
                                case DOUBLE: {
                                    type = Double.TYPE;
                                    break block14;
                                }
                                case INT: {
                                    type = Integer.TYPE;
                                    break block14;
                                }
                                case FLOAT: {
                                    type = Float.TYPE;
                                    break block14;
                                }
                                case LONG: {
                                    type = Long.TYPE;
                                    break block14;
                                }
                                case SHORT: {
                                    type = Short.TYPE;
                                    break block14;
                                }
                                default: {
                                    throw new IllegalArgumentException("Not a supported primitive type: " + injectionPoint.getRequiredType().asPrimitiveType().primitive());
                                }
                            }
                        }
                        type = tccl.loadClass(injectionPoint.getRequiredType().name().toString());
                    }
                    if (config.getOptionalValue(key, type).isPresent() || (defaultValue = configProperty.value("defaultValue")) != null && !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue.asString())) continue;
                    validationContext.addDeploymentProblem((Throwable)new IllegalStateException("No config value exists for: " + key));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to verify config injection point: " + injectionPoint, e);
                }
            }
        }
    }
}

