/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.runtime.annotations.Template;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Template
public class ConfigDeploymentTemplate {
    public void validateConfigProperties(Map<String, Set<Class<?>>> properties) {
        Config config = ConfigProviderResolver.instance().getConfig();
        for (Map.Entry<String, Set<Class<?>>> entry : properties.entrySet()) {
            Set<Class<?>> propertyTypes = entry.getValue();
            for (Class<Object> propertyType : propertyTypes) {
                if (Collection.class.isAssignableFrom(propertyType)) {
                    propertyType = String.class;
                }
                if (config.getOptionalValue(entry.getKey(), propertyType).isPresent()) continue;
                throw new DeploymentException("No config value of type " + entry.getValue() + " exists for: " + entry.getKey());
            }
        }
    }
}

