/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.context;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ManagedContext;
import java.util.Collection;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ArcContextProvider
implements ThreadContextProvider {
    private static ThreadContextSnapshot NOOP_SNAPSHOT = () -> () -> {};

    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        if (!this.isContextActiveOnThisThread(arc)) {
            return NOOP_SNAPSHOT;
        }
        Collection instancesToPropagate = arc.requestContext().getAll();
        return () -> {
            ThreadContextController controller;
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                throw new IllegalStateException("Arc context propagation was attempted but the container is not running.");
            }
            ManagedContext requestContext = arcContainer.requestContext();
            if (this.isContextActiveOnThisThread(arcContainer)) {
                Collection instancesToRestore = requestContext.getAll();
                requestContext.deactivate();
                requestContext.activate(instancesToPropagate);
                controller = () -> {
                    requestContext.deactivate();
                    requestContext.activate(instancesToRestore);
                };
            } else {
                requestContext.activate(instancesToPropagate);
                controller = () -> requestContext.deactivate();
            }
            return controller;
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        if (!this.isContextActiveOnThisThread(arc)) {
            return NOOP_SNAPSHOT;
        }
        return () -> {
            ThreadContextController controller;
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                throw new IllegalStateException("Arc context propagation was attempted but the container is not running.");
            }
            ManagedContext requestContext = arcContainer.requestContext();
            if (this.isContextActiveOnThisThread(arcContainer)) {
                Collection instancesToRestore = requestContext.getAll();
                requestContext.deactivate();
                requestContext.activate();
                controller = () -> {
                    requestContext.deactivate();
                    requestContext.activate(instancesToRestore);
                };
            } else {
                requestContext.activate();
                controller = () -> requestContext.deactivate();
            }
            return controller;
        };
    }

    public String getThreadContextType() {
        return "CDI";
    }

    private boolean isContextActiveOnThisThread(ArcContainer arc) {
        return arc.requestContext().isActive();
    }
}

