/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.devconsole.Invocation;
import io.quarkus.arc.runtime.devconsole.InvocationTree;
import io.quarkus.arc.runtime.devconsole.InvocationsMonitor;
import io.quarkus.arc.runtime.devconsole.Monitored;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Priority(value=1000)
@Monitored
@Interceptor
public class InvocationInterceptor {
    @Inject
    InvocationsMonitor invocationMonitor;
    @Intercepted
    InjectableBean<?> bean;
    @Inject
    Instance<InvocationTree> invocationTree;

    @AroundInvoke
    public Object monitor(InvocationContext context) throws Exception {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            InvocationTree tree = (InvocationTree)this.invocationTree.get();
            return this.proceed(tree.invocationStarted(this.bean, context.getMethod(), this.getKind(context)), context, requestContext, tree);
        }
        return this.proceed(new Invocation.Builder().setInterceptedBean(this.bean).setMethod(context.getMethod()).setKind(this.getKind(context)).setStart(System.currentTimeMillis()), context, requestContext, null);
    }

    Object proceed(Invocation.Builder builder, InvocationContext context, ManagedContext requestContext, InvocationTree tree) throws Exception {
        long nanoTime = System.nanoTime();
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            builder.setMessage(e.getMessage());
            throw e;
        }
        finally {
            builder.setDuration(System.nanoTime() - nanoTime);
            if (builder.getParent() == null) {
                this.invocationMonitor.addInvocation(builder.build());
            }
            if (tree != null && requestContext.isActive()) {
                tree.invocationCompleted();
            }
        }
    }

    Invocation.Kind getKind(InvocationContext ctx) {
        Annotation[][] parameterAnnotations;
        Method method = ctx.getMethod();
        if (!method.getReturnType().equals(Void.TYPE) && method.isAnnotationPresent(Produces.class)) {
            return Invocation.Kind.PRODUCER;
        }
        if (method.getParameterCount() > 0 && (parameterAnnotations = method.getParameterAnnotations()).length > 0) {
            Annotation[][] annotationArray = parameterAnnotations;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    Class<? extends Annotation> type = annotation.annotationType();
                    if (Observes.class.equals(type) || ObservesAsync.class.equals(type)) {
                        return Invocation.Kind.OBSERVER;
                    }
                    if (!Disposes.class.equals(type)) continue;
                    return Invocation.Kind.DISPOSER;
                }
            }
        }
        return Invocation.Kind.BUSINESS;
    }
}

