/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.devconsole;

import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Singleton
public class EventsMonitor {
    private static final int DEFAULT_LIMIT = 500;
    private volatile boolean skipContextEvents = true;
    private final List<EventInfo> events = Collections.synchronizedList(new ArrayList(500));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(@Observes Object payload, EventMetadata eventMetadata) {
        if (this.skipContextEvents && this.isContextEvent(eventMetadata)) {
            return;
        }
        if (this.events.size() > 500) {
            List<EventInfo> list = this.events;
            synchronized (list) {
                if (this.events.size() > 500) {
                    this.events.subList(0, 250).clear();
                }
            }
        }
        this.events.add(EventInfo.from(eventMetadata));
    }

    public void clear() {
        this.events.clear();
    }

    public List<EventInfo> getLastEvents() {
        ArrayList<EventInfo> result = new ArrayList<EventInfo>(this.events);
        Collections.reverse(result);
        return result;
    }

    public boolean isSkipContextEvents() {
        return this.skipContextEvents;
    }

    public void toggleSkipContextEvents() {
        this.skipContextEvents = !this.skipContextEvents;
    }

    boolean isContextEvent(EventMetadata eventMetadata) {
        if (!eventMetadata.getType().equals(Object.class) || eventMetadata.getQualifiers().size() != 2) {
            return false;
        }
        for (Annotation qualifier : eventMetadata.getQualifiers()) {
            Class<? extends Annotation> qualifierType = qualifier.annotationType();
            if (qualifierType.equals(Any.class) || qualifierType.equals(Initialized.class) || qualifierType.equals(BeforeDestroyed.class) || qualifierType.equals(Destroyed.class)) continue;
            return false;
        }
        return true;
    }

    static class EventInfo {
        private final LocalDateTime timestamp = LocalDateTime.now();
        private final Type type;
        private final List<Annotation> qualifiers;

        static EventInfo from(EventMetadata eventMetadata) {
            List<Annotation> qualifiers;
            if (eventMetadata.getQualifiers().size() == 1) {
                qualifiers = Collections.emptyList();
            } else {
                qualifiers = new ArrayList(1);
                for (Annotation qualifier : eventMetadata.getQualifiers()) {
                    if (qualifier.annotationType().equals(Any.class) || qualifier.annotationType().equals(Default.class)) continue;
                    qualifiers.add(qualifier);
                }
            }
            return new EventInfo(eventMetadata.getType(), qualifiers);
        }

        EventInfo(Type type, List<Annotation> qualifiers) {
            this.type = type;
            this.qualifiers = qualifiers;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public String getType() {
            return this.type.getTypeName();
        }

        public List<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }
}

