/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arquillian;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MethodParameterInjectionPoint<T>
implements InjectionPoint {
    private Method method;
    private int position;

    public MethodParameterInjectionPoint(Method method, int position) {
        this.method = method;
        this.position = position;
    }

    public Bean<?> getBean() {
        return null;
    }

    public Member getMember() {
        return this.method;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation potentialQualifier : this.method.getParameterAnnotations()[this.position]) {
            if (potentialQualifier.annotationType().getAnnotation(Qualifier.class) == null) continue;
            qualifiers.add(potentialQualifier);
        }
        if (qualifiers.size() == 0) {
            qualifiers.add((Annotation)Default.Literal.INSTANCE);
        }
        return qualifiers;
    }

    public Type getType() {
        return this.findTypeOrGenericType();
    }

    public boolean isDelegate() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public Annotated getAnnotated() {
        return new ArgumentAnnotated();
    }

    private Type findTypeOrGenericType() {
        Type[] genericParameterTypes = this.method.getGenericParameterTypes();
        if (genericParameterTypes.length > 0) {
            return genericParameterTypes[this.position];
        }
        return this.method.getParameterTypes()[this.position];
    }

    private class ArgumentAnnotated<X>
    implements AnnotatedParameter<X> {
        private ArgumentAnnotated() {
        }

        public AnnotatedCallable<X> getDeclaringCallable() {
            return null;
        }

        public int getPosition() {
            return MethodParameterInjectionPoint.this.position;
        }

        public <Y extends Annotation> Y getAnnotation(Class<Y> annotationType) {
            for (Annotation annotation : MethodParameterInjectionPoint.this.method.getParameterAnnotations()[MethodParameterInjectionPoint.this.position]) {
                if (annotation.annotationType() != annotationType) continue;
                return (Y)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return new HashSet<Annotation>(Arrays.asList(MethodParameterInjectionPoint.this.method.getParameterAnnotations()[MethodParameterInjectionPoint.this.position]));
        }

        public Type getBaseType() {
            return MethodParameterInjectionPoint.this.getType();
        }

        public Set<Type> getTypeClosure() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(MethodParameterInjectionPoint.this.findTypeOrGenericType());
            types.add((Type)((Object)Object.class));
            return types;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }
    }
}

