/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arquillian;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arquillian.MethodParameterInjectionPoint;
import io.quarkus.arquillian.QuarkusDeployment;
import io.quarkus.arquillian.QuarkusProtocol;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.logging.Logger;

public class InjectionEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger((String)TestEnricher.class.getName());
    @Inject
    @TestScoped
    private InstanceProducer<CreationContextHolder> creationalContextProducer;
    @Inject
    @DeploymentScoped
    private Instance<QuarkusDeployment> deployment;

    public void enrich(Object testCase) {
    }

    public Object[] resolve(Method method) {
        if (method.getParameterCount() > 0) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                CreationContextHolder holder = this.getCreationalContext();
                ClassLoader cl = this.deployment.get() != null && ((QuarkusDeployment)this.deployment.get()).hasAppClassLoader() ? ((QuarkusDeployment)this.deployment.get()).getAppClassLoader() : this.getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                Class<?> c = cl.loadClass(IsolatedEnricher.class.getName());
                BiFunction function = (BiFunction)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object[] objectArray = (Object[])function.apply(method, holder.creationalContext);
                return objectArray;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        return new Object[0];
    }

    private CreationContextHolder getCreationalContext() {
        try {
            ClassLoader cl = this.deployment.get() != null && ((QuarkusDeployment)this.deployment.get()).hasAppClassLoader() ? ((QuarkusDeployment)this.deployment.get()).getAppClassLoader() : this.getClass().getClassLoader();
            Class<?> c = cl.loadClass(IsolatedCreationContextCreator.class.getName());
            Supplier supplier = (Supplier)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map.Entry val = (Map.Entry)supplier.get();
            return new CreationContextHolder((Closeable)val.getKey(), val.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class CreationContextHolder
    implements Closeable {
        final Closeable closeable;
        final Object creationalContext;

        public CreationContextHolder(Closeable closeable, Object creationalContext) {
            this.closeable = closeable;
            this.creationalContext = creationalContext;
        }

        @Override
        public void close() throws IOException {
            if (this.closeable != null) {
                this.closeable.close();
            } else {
                ((CreationalContext)this.creationalContext).release();
            }
        }
    }

    public static class IsolatedEnricher
    implements BiFunction<Method, Object, Object[]> {
        private <T> T getInstanceByType(BeanManager manager, int position, Method method, CreationalContext<?> cc) {
            return (T)manager.getInjectableReference(new MethodParameterInjectionPoint(method, position), cc);
        }

        private BeanManager getBeanManager() {
            ArcContainer container = Arc.container();
            if (container == null) {
                return null;
            }
            return container.beanManager();
        }

        @Override
        public Object[] apply(Method method, Object creationalContext) {
            Object[] values = new Object[method.getParameterCount()];
            boolean hasNonArquillianDataProvider = false;
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().getName().equals("org.testng.annotations.Test")) continue;
                try {
                    Method dataProviderMember = annotation.annotationType().getDeclaredMethod("dataProvider", new Class[0]);
                    String value = dataProviderMember.invoke((Object)annotation, new Object[0]).toString();
                    hasNonArquillianDataProvider = !value.equals("") && !value.equals("ARQUILLIAN_DATA_PROVIDER");
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            if (hasNonArquillianDataProvider) {
                return values;
            }
            BeanManager beanManager = this.getBeanManager();
            if (beanManager == null) {
                return values;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            try {
                method = this.getClass().getClassLoader().loadClass(method.getDeclaringClass().getName()).getMethod(method.getName(), QuarkusProtocol.convertToCL(parameterTypes, this.getClass().getClassLoader()));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                try {
                    values[i] = this.getInstanceByType(beanManager, i, method, (CreationalContext)creationalContext);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("InjectionEnricher tried to lookup method parameter of type " + parameterTypes[i] + " but caught exception"), (Throwable)e);
                }
            }
            return values;
        }
    }

    public static class IsolatedCreationContextCreator
    implements Supplier<Map.Entry<Closeable, Object>> {
        private BeanManager getBeanManager() {
            ArcContainer container = Arc.container();
            if (container == null) {
                return null;
            }
            return container.beanManager();
        }

        @Override
        public Map.Entry<Closeable, Object> get() {
            final CreationalContext cc = this.getBeanManager().createCreationalContext(null);
            return new Map.Entry<Closeable, Object>(){

                @Override
                public Closeable getKey() {
                    return new Closeable(){

                        @Override
                        public void close() throws IOException {
                            cc.release();
                        }
                    };
                }

                @Override
                public Object getValue() {
                    return cc;
                }

                @Override
                public Object setValue(Object value) {
                    return null;
                }
            };
        }
    }
}

