/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arquillian;

import io.quarkus.arquillian.QuarkusDeployableContainer;
import io.quarkus.arquillian.QuarkusDeployment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.test.impl.client.protocol.local.LocalDeploymentPackager;
import org.jboss.arquillian.container.test.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.protocol.Protocol;
import org.jboss.arquillian.container.test.spi.client.protocol.ProtocolConfiguration;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

class QuarkusProtocol
implements Protocol<QuarkusProtocolConfiguration> {
    @Inject
    Instance<Injector> injector;

    QuarkusProtocol() {
    }

    public Class<QuarkusProtocolConfiguration> getProtocolConfigurationClass() {
        return QuarkusProtocolConfiguration.class;
    }

    public ProtocolDescription getDescription() {
        return new ProtocolDescription("Quarkus");
    }

    public DeploymentPackager getPackager() {
        return new LocalDeploymentPackager();
    }

    public ContainerMethodExecutor getExecutor(QuarkusProtocolConfiguration protocolConfiguration, ProtocolMetaData metaData, CommandCallback callback) {
        return (ContainerMethodExecutor)((Injector)this.injector.get()).inject((Object)new QuarkusMethodExecutor());
    }

    static Class<?>[] convertToTCCL(Class<?>[] classes) throws ClassNotFoundException {
        return QuarkusProtocol.convertToCL(classes, Thread.currentThread().getContextClassLoader());
    }

    static Class<?>[] convertToCL(Class<?>[] classes, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] result = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = classes[i].getClassLoader() != classLoader ? classLoader.loadClass(classes[i].getName()) : classes[i];
        }
        return result;
    }

    public static class QuarkusProtocolConfiguration
    implements ProtocolConfiguration {
    }

    static class QuarkusMethodExecutor
    implements ContainerMethodExecutor {
        @Inject
        Event<LocalExecutionEvent> event;
        @Inject
        Instance<TestResult> testResult;
        @Inject
        Instance<QuarkusDeployment> deployment;

        QuarkusMethodExecutor() {
        }

        public TestResult invoke(final TestMethodExecutor testMethodExecutor) {
            this.event.fire((Object)new LocalExecutionEvent(new TestMethodExecutor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void invoke(Object ... parameters) throws Throwable {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(((QuarkusDeployment)deployment.get()).getAppClassLoader());
                        Object actualTestInstance = QuarkusDeployableContainer.testInstance;
                        Method actualMethod = null;
                        try {
                            actualMethod = actualTestInstance.getClass().getMethod(this.getMethod().getName(), QuarkusProtocol.convertToTCCL(this.getMethod().getParameterTypes()));
                        }
                        catch (NoSuchMethodException e) {
                            actualMethod = actualTestInstance.getClass().getDeclaredMethod(this.getMethod().getName(), QuarkusProtocol.convertToTCCL(this.getMethod().getParameterTypes()));
                            actualMethod.setAccessible(true);
                        }
                        try {
                            actualMethod.invoke(actualTestInstance, parameters);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause != null) {
                                throw cause;
                            }
                            throw e;
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }

                public Method getMethod() {
                    return testMethodExecutor.getMethod();
                }

                public Object getInstance() {
                    return QuarkusDeployableContainer.testInstance;
                }

                public String getMethodName() {
                    return testMethodExecutor.getMethod().getName();
                }
            }));
            return (TestResult)this.testResult.get();
        }
    }
}

