/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.avro.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Collection;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.specific.AvroGenerated;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class AvroProcessor {
    @BuildStep
    public void build(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageSystemPropertyBuildItem> sys, BuildProducer<NativeImageConfigBuildItem> conf) {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
        builder.addRuntimeInitializedClass(GenericDatumReader.class.getName());
        Collection annotations = indexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)AvroGenerated.class.getName()));
        for (AnnotationInstance annotation : annotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            String className = annotation.target().asClass().name().toString();
            builder.addRuntimeInitializedClass(className);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{className}));
        }
        builder.addRuntimeInitializedClass("org.apache.avro.reflect.ReflectData");
        conf.produce((BuildItem)builder.build());
        sys.produce((BuildItem)new NativeImageSystemPropertyBuildItem("avro.disable.unsafe", "true"));
    }
}

