/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.avro.deployment;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.jboss.logging.Logger;

public abstract class AvroCodeGenProviderBase
implements CodeGenProvider {
    private static final Logger log = Logger.getLogger(AvroCodeGenProviderBase.class);
    static final String templateDirectory = "/org/apache/avro/compiler/specific/templates/java/classic/";

    public String inputDirectory() {
        return "avro";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        this.init();
        boolean filesGenerated = false;
        AvroOptions options = new AvroOptions(context.properties(), this.inputExtension());
        Path input = context.inputDir();
        Path outputDir = context.outDir();
        HashSet<Path> importedPaths = new HashSet<Path>();
        for (String imprt : options.imports) {
            Path importPath = Paths.get(input.toAbsolutePath().toString(), imprt.trim()).toAbsolutePath();
            if (Files.isDirectory(importPath, new LinkOption[0])) {
                for (Path file : this.gatherAllFiles(importPath)) {
                    this.compileSingleFile(file, outputDir, options);
                    importedPaths.add(file);
                    filesGenerated = true;
                }
                continue;
            }
            this.compileSingleFile(importPath, outputDir, options);
            importedPaths.add(importPath);
            filesGenerated = true;
        }
        for (Path file : this.gatherAllFiles(input)) {
            if (importedPaths.contains(file)) continue;
            this.compileSingleFile(file, outputDir, options);
            filesGenerated = true;
        }
        return filesGenerated;
    }

    abstract void init();

    private Collection<Path> gatherAllFiles(Path importPath) throws CodeGenException {
        try {
            return Files.find(importPath, 20, (path, ignored) -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith("." + this.inputExtension()), new FileVisitOption[0]).map(Path::toAbsolutePath).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to list matching files in " + importPath, (Throwable)e);
        }
    }

    abstract void compileSingleFile(Path var1, Path var2, AvroOptions var3) throws CodeGenException;

    public static class AvroOptions {
        public static final String[] EMPTY = new String[0];
        private final Map<String, String> properties;
        final String[] imports;
        final GenericData.StringType stringType;
        final boolean createOptionalGetters;
        final boolean enableDecimalLogicalType;
        final boolean createSetters;
        final boolean gettersReturnOptional;
        final boolean optionalGettersForNullableFieldsOnly;

        AvroOptions(Map<String, String> properties, String specificPropertyKey) {
            this.properties = properties;
            String imports = this.prop("avro.codegen." + specificPropertyKey + ".imports", "");
            this.imports = "".equals(imports) ? EMPTY : imports.split(",");
            this.stringType = GenericData.StringType.valueOf((String)this.prop("avro.codegen.stringType", "String"));
            this.createOptionalGetters = this.getBooleanProperty("avro.codegen.createOptionalGetters", false);
            this.enableDecimalLogicalType = this.getBooleanProperty("avro.codegen.enableDecimalLogicalType", false);
            this.createSetters = this.getBooleanProperty("avro.codegen.createSetters", true);
            this.gettersReturnOptional = this.getBooleanProperty("avro.codegen.gettersReturnOptional", false);
            this.optionalGettersForNullableFieldsOnly = this.getBooleanProperty("avro.codegen.optionalGettersForNullableFieldsOnly", false);
        }

        private String prop(String propName, String defaultValue) {
            return this.properties.getOrDefault(propName, defaultValue);
        }

        private boolean getBooleanProperty(String propName, boolean defaultValue) {
            String value = this.prop(propName, String.valueOf(defaultValue)).toLowerCase(Locale.ROOT);
            if (Boolean.FALSE.toString().equals(value)) {
                return false;
            }
            if (Boolean.TRUE.toString().equals(value)) {
                return true;
            }
            return defaultValue;
        }
    }
}

