/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.awt.runtime.graal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.quarkus.runtime.util.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticFeature
@Platforms(value={Platform.DARWIN_AMD64.class, Platform.DARWIN_AARCH64.class})
public class DarwinAwtFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (JavaVersionUtil.isJava17OrHigher()) {
            RuntimeClassInitializationSupport runtimeInit = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
            String reason = "Quarkus run time init for AWT in Darwin";
            runtimeInit.initializeAtRunTime("sun.lwawt.macosx", "Quarkus run time init for AWT in Darwin");
        }
    }
}

