/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.azure.functions.resteasy.runtime;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.netty.runtime.virtual.VirtualResponseHandler;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import java.io.ByteArrayOutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jboss.logging.Logger;

public class BaseFunction {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.azure");
    private static final int BUFFER_SIZE = 8096;

    protected HttpResponseMessage dispatch(HttpRequestMessage<Optional<String>> request) {
        try {
            return this.nettyDispatch(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return request.createResponseBuilder(HttpStatus.valueOf((int)500)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponseMessage nettyDispatch(HttpRequestMessage<Optional<String>> request) throws Exception {
        Object path = request.getUri().getRawPath();
        String query = request.getUri().getRawQuery();
        if (query != null) {
            path = (String)path + "?" + query;
        }
        Object host = request.getUri().getHost();
        if (request.getUri().getPort() != -1) {
            host = (String)host + ":" + request.getUri().getPort();
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getHttpMethod().name()), (String)path);
        nettyRequest.headers().set("Host", host);
        for (Map.Entry header : request.getHeaders().entrySet()) {
            nettyRequest.headers().add((String)header.getKey(), header.getValue());
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (((Optional)request.getBody()).isPresent()) {
            ByteBuf body = Unpooled.wrappedBuffer((byte[])((String)((Optional)request.getBody()).get()).getBytes());
            requestContent = new DefaultLastHttpContent(body);
        }
        ResponseHandler handler = new ResponseHandler(request);
        VirtualClientConnection connection = VirtualClientConnection.connect((VirtualResponseHandler)handler, (VirtualAddress)VertxHttpRecorder.VIRTUAL_HTTP);
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
        try {
            HttpResponseMessage httpResponseMessage = handler.future.get();
            return httpResponseMessage;
        }
        finally {
            connection.close();
        }
    }

    private static ByteArrayOutputStream createByteStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8096);
        return baos;
    }

    private static class ResponseHandler
    implements VirtualResponseHandler {
        HttpResponseMessage.Builder responseBuilder;
        ByteArrayOutputStream baos;
        WritableByteChannel byteChannel;
        CompletableFuture<HttpResponseMessage> future = new CompletableFuture();
        final HttpRequestMessage<Optional<String>> request;

        public ResponseHandler(HttpRequestMessage<Optional<String>> request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Object msg) {
            try {
                FileRegion file;
                if (msg instanceof HttpResponse) {
                    HttpResponse res = (HttpResponse)msg;
                    this.responseBuilder = this.request.createResponseBuilder(HttpStatus.valueOf((int)res.status().code()));
                    for (Map.Entry entry : res.headers()) {
                        if (((String)entry.getKey()).equalsIgnoreCase("Transfer-Encoding") && ((String)entry.getValue()).contains("chunked")) continue;
                        this.responseBuilder.header((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    if (this.baos == null) {
                        this.baos = BaseFunction.createByteStream();
                    }
                    int readable = content.content().readableBytes();
                    for (int i = 0; i < readable; ++i) {
                        this.baos.write(content.content().readByte());
                    }
                }
                if (msg instanceof FileRegion && (file = (FileRegion)msg).count() > 0L && file.transferred() < file.count()) {
                    if (this.baos == null) {
                        this.baos = BaseFunction.createByteStream();
                    }
                    if (this.byteChannel == null) {
                        this.byteChannel = Channels.newChannel(this.baos);
                    }
                    file.transferTo(this.byteChannel, file.transferred());
                }
                if (msg instanceof LastHttpContent) {
                    this.responseBuilder.body((Object)this.baos.toByteArray());
                    this.future.complete(this.responseBuilder.build());
                }
            }
            catch (Throwable ex) {
                this.future.completeExceptionally(ex);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }

        public void close() {
            if (!this.future.isDone()) {
                this.future.completeExceptionally(new RuntimeException("Connection closed"));
            }
        }
    }
}

