/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.PathsCollection;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistentAppModel
implements Serializable {
    private final String baseName;
    private final SerializedDep appArtifact;
    private final List<SerializedDep> deploymentDeps = new ArrayList<SerializedDep>();
    private final List<SerializedDep> fullDeploymentDeps = new ArrayList<SerializedDep>();
    private final List<SerializedDep> runtimeDeps = new ArrayList<SerializedDep>();
    private final Set<AppArtifactKey> parentFirstArtifacts = new HashSet<AppArtifactKey>();
    private final Set<AppArtifactKey> lesserPriorityArtifacts = new HashSet<AppArtifactKey>();
    private final Set<AppArtifactKey> localProjectArtifacts = new HashSet<AppArtifactKey>();

    public PersistentAppModel(String baseName, Map<AppArtifactKey, List<String>> paths, AppModel appModel, String appArchivePath) {
        this.baseName = baseName;
        this.appArtifact = new SerializedDep(appModel.getAppArtifact(), paths);
        this.appArtifact.paths = Collections.singletonList(appArchivePath);
        for (AppDependency i : appModel.getDeploymentDependencies()) {
            this.deploymentDeps.add(new SerializedDep(i, paths));
        }
        for (AppDependency i : appModel.getFullDeploymentDeps()) {
            this.fullDeploymentDeps.add(new SerializedDep(i, paths));
        }
        for (AppDependency i : appModel.getUserDependencies()) {
            this.runtimeDeps.add(new SerializedDep(i, paths));
        }
        this.localProjectArtifacts.addAll(appModel.getLocalProjectArtifacts());
        this.parentFirstArtifacts.addAll(appModel.getParentFirstArtifacts());
        this.lesserPriorityArtifacts.addAll(appModel.getLesserPriorityArtifacts());
    }

    public AppModel getAppModel(Path root) {
        AppModel.Builder model = new AppModel.Builder();
        model.setAppArtifact(this.appArtifact.getDep(root).getArtifact());
        for (SerializedDep serializedDep : this.deploymentDeps) {
            model.addDeploymentDep(serializedDep.getDep(root));
        }
        for (SerializedDep serializedDep : this.fullDeploymentDeps) {
            model.addFullDeploymentDep(serializedDep.getDep(root));
        }
        for (SerializedDep serializedDep : this.runtimeDeps) {
            model.addRuntimeDep(serializedDep.getDep(root));
        }
        for (AppArtifactKey appArtifactKey : this.parentFirstArtifacts) {
            model.addParentFirstArtifact(appArtifactKey);
        }
        for (AppArtifactKey appArtifactKey : this.lesserPriorityArtifacts) {
            model.addLesserPriorityArtifact(appArtifactKey);
        }
        for (AppArtifactKey appArtifactKey : this.localProjectArtifacts) {
            model.addLocalProjectArtifact(appArtifactKey);
        }
        return model.build();
    }

    public String getBaseName() {
        return this.baseName;
    }

    private static class SerializedDep
    extends AppArtifactCoords {
        private List<String> paths;

        public SerializedDep(AppArtifact dependency, Map<AppArtifactKey, List<String>> paths) {
            super(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
            this.paths = paths.get(dependency.getKey());
        }

        public SerializedDep(AppDependency dependency, Map<AppArtifactKey, List<String>> paths) {
            this(dependency.getArtifact(), paths);
        }

        public AppDependency getDep(Path root) {
            PathsCollection.Builder builder = PathsCollection.builder();
            for (String i : this.paths) {
                builder.add(root.resolve(i));
            }
            AppArtifact appArtifact = new AppArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getType(), this.getVersion());
            appArtifact.setPaths(builder.build());
            return new AppDependency(appArtifact, "compile", false);
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }
}

