/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PersistentAppModel
implements Serializable {
    private final String baseName;
    private final SerializedDep appArtifact;
    private List<SerializedDep> deploymentDeps;
    private List<SerializedDep> fullDeploymentDeps;
    private List<SerializedDep> runtimeDeps;
    private Set<AppArtifactKey> parentFirstArtifacts;
    private Set<AppArtifactKey> runnerParentFirstArtifacts;
    private Set<AppArtifactKey> lesserPriorityArtifacts;
    private Set<AppArtifactKey> localProjectArtifacts;
    private Map<String, String> platformProperties;
    private Map<String, CapabilityContract> capabilitiesContracts;
    private String userProvidersDirectory;

    public PersistentAppModel(String baseName, Map<AppArtifactKey, List<String>> paths, AppModel appModel, String userProvidersDirectory, String appArchivePath) {
        this.baseName = baseName;
        this.userProvidersDirectory = userProvidersDirectory;
        this.appArtifact = new SerializedDep(appModel.getAppArtifact(), paths);
        this.appArtifact.paths = Collections.singletonList(appArchivePath.replace("\\", "/"));
        this.deploymentDeps = new ArrayList<SerializedDep>(appModel.getDeploymentDependencies().size());
        for (AppDependency i : appModel.getDeploymentDependencies()) {
            this.deploymentDeps.add(new SerializedDep(i, paths));
        }
        this.fullDeploymentDeps = new ArrayList<SerializedDep>(appModel.getFullDeploymentDeps().size());
        for (AppDependency i : appModel.getFullDeploymentDeps()) {
            this.fullDeploymentDeps.add(new SerializedDep(i, paths));
        }
        this.runtimeDeps = new ArrayList<SerializedDep>(appModel.getUserDependencies().size());
        for (AppDependency i : appModel.getUserDependencies()) {
            this.runtimeDeps.add(new SerializedDep(i, paths));
        }
        this.platformProperties = new HashMap<String, String>(appModel.getPlatformProperties());
        this.localProjectArtifacts = new HashSet<AppArtifactKey>(appModel.getLocalProjectArtifacts());
        this.parentFirstArtifacts = new HashSet<AppArtifactKey>(appModel.getParentFirstArtifacts());
        this.runnerParentFirstArtifacts = new HashSet<AppArtifactKey>(appModel.getRunnerParentFirstArtifacts());
        this.lesserPriorityArtifacts = new HashSet<AppArtifactKey>(appModel.getLesserPriorityArtifacts());
        this.capabilitiesContracts = new HashMap<String, CapabilityContract>(appModel.getCapabilityContracts());
    }

    public String getUserProvidersDirectory() {
        return this.userProvidersDirectory;
    }

    public AppModel getAppModel(Path root) {
        AppModel.Builder model = new AppModel.Builder();
        model.setAppArtifact(this.appArtifact.getDep(root).getArtifact());
        for (SerializedDep serializedDep : this.deploymentDeps) {
            model.addDeploymentDep(serializedDep.getDep(root));
        }
        for (SerializedDep serializedDep : this.fullDeploymentDeps) {
            model.addFullDeploymentDep(serializedDep.getDep(root));
        }
        for (SerializedDep serializedDep : this.runtimeDeps) {
            model.addRuntimeDep(serializedDep.getDep(root));
        }
        for (AppArtifactKey appArtifactKey : this.parentFirstArtifacts) {
            model.addParentFirstArtifact(appArtifactKey);
        }
        for (AppArtifactKey appArtifactKey : this.runnerParentFirstArtifacts) {
            model.addRunnerParentFirstArtifact(appArtifactKey);
        }
        for (AppArtifactKey appArtifactKey : this.lesserPriorityArtifacts) {
            model.addLesserPriorityArtifact(appArtifactKey);
        }
        for (AppArtifactKey appArtifactKey : this.localProjectArtifacts) {
            model.addLocalProjectArtifact(appArtifactKey);
        }
        model.setCapabilitiesContracts(this.capabilitiesContracts);
        PlatformImportsImpl pi = new PlatformImportsImpl();
        pi.setPlatformProperties(this.platformProperties);
        model.setPlatformImports(pi);
        return model.build();
    }

    public String getBaseName() {
        return this.baseName;
    }

    private static class SerializedDep
    extends AppArtifactCoords {
        private List<String> paths;

        public SerializedDep(AppArtifact dependency, Map<AppArtifactKey, List<String>> paths) {
            super(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
            List<String> pathList = paths.get(dependency.getKey());
            if (pathList == null) {
                pathList = Collections.emptyList();
            }
            this.paths = pathList.stream().map(s -> s.replace("\\", "/")).collect(Collectors.toList());
        }

        public SerializedDep(AppDependency dependency, Map<AppArtifactKey, List<String>> paths) {
            this(dependency.getArtifact(), paths);
        }

        public AppDependency getDep(Path root) {
            PathsCollection.Builder builder = PathsCollection.builder();
            for (String i : this.paths) {
                builder.add(root.resolve(i));
            }
            AppArtifact appArtifact = new AppArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getType(), this.getVersion());
            appArtifact.setPaths(builder.build());
            return new AppDependency(appArtifact, "compile", false);
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }
}

