/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public abstract class PathTreeWithManifest
implements PathTree {
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    public static final int JAVA_VERSION;
    protected boolean manifestEnabled;
    private final ReentrantReadWriteLock manifestInfoLock = new ReentrantReadWriteLock();
    private transient Manifest manifest;
    protected transient boolean manifestInitialized;
    protected volatile Map<String, String> multiReleaseMapping;

    protected PathTreeWithManifest() {
        this(true);
    }

    protected PathTreeWithManifest(boolean manifestEnabled) {
        this.manifestEnabled = manifestEnabled;
        if (!manifestEnabled) {
            this.manifestInitialized = true;
            this.multiReleaseMapping = Collections.emptyMap();
        }
    }

    protected PathTreeWithManifest(PathTreeWithManifest pathTreeWithManifest) {
        pathTreeWithManifest.manifestReadLock().lock();
        try {
            this.manifest = pathTreeWithManifest.manifest;
            this.manifestInitialized = pathTreeWithManifest.manifestInitialized;
            this.multiReleaseMapping = pathTreeWithManifest.multiReleaseMapping;
        }
        finally {
            pathTreeWithManifest.manifestReadLock().unlock();
        }
        this.manifestEnabled = pathTreeWithManifest.manifestEnabled;
    }

    @Override
    public <T> T apply(String relativePath, Function<PathVisit, T> func) {
        return this.apply(relativePath, func, this.manifestEnabled);
    }

    protected abstract <T> T apply(String var1, Function<PathVisit, T> var2, boolean var3);

    @Override
    public Manifest getManifest() {
        this.manifestReadLock().lock();
        try {
            if (this.manifestInitialized) {
                Manifest manifest = this.manifest;
                return manifest;
            }
        }
        finally {
            this.manifestReadLock().unlock();
        }
        this.manifestWriteLock().lock();
        try {
            if (this.manifestInitialized) {
                Manifest manifest = this.manifest;
                return manifest;
            }
            Manifest m = this.apply("META-INF/MANIFEST.MF", ManifestReader.INSTANCE, false);
            this.initManifest(m);
        }
        finally {
            this.manifestWriteLock().unlock();
        }
        return this.manifest;
    }

    protected void initManifest(Manifest m) {
        this.manifest = m;
        this.manifestInitialized = true;
    }

    protected ReentrantReadWriteLock.WriteLock manifestWriteLock() {
        return this.manifestInfoLock.writeLock();
    }

    protected ReentrantReadWriteLock.ReadLock manifestReadLock() {
        return this.manifestInfoLock.readLock();
    }

    public boolean isMultiReleaseJar() {
        return PathTreeWithManifest.isMultiReleaseJar(this.getManifest());
    }

    protected Map<String, String> getMultiReleaseMapping() {
        if (this.multiReleaseMapping != null) {
            return this.multiReleaseMapping;
        }
        Map<String, String> mrMapping = this.isMultiReleaseJar() ? this.apply(META_INF_VERSIONS, MultiReleaseMappingReader.INSTANCE, false) : Collections.emptyMap();
        this.initMultiReleaseMapping(mrMapping);
        return mrMapping;
    }

    protected void initMultiReleaseMapping(Map<String, String> mrMapping) {
        this.multiReleaseMapping = mrMapping;
    }

    protected String toMultiReleaseRelativePath(String relativePath) {
        return this.getMultiReleaseMapping().getOrDefault(relativePath, relativePath);
    }

    private static boolean isMultiReleaseJar(Manifest m) {
        return m != null && Boolean.parseBoolean(m.getMainAttributes().getValue("Multi-Release"));
    }

    static {
        try {
            String versionStr = "version";
            Object v = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            List list = (List)v.getClass().getMethod("version", new Class[0]).invoke(v, new Object[0]);
            JAVA_VERSION = (Integer)list.get(0);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to obtain the Java vesion from java.lang.Runtime, possibly it's Java 8 which is not supported anymore", e);
        }
    }

    private static class ManifestReader
    implements Function<PathVisit, Manifest> {
        private static final ManifestReader INSTANCE = new ManifestReader();

        private ManifestReader() {
        }

        @Override
        public Manifest apply(PathVisit visit) {
            Manifest manifest;
            block9: {
                if (visit == null) {
                    return null;
                }
                InputStream is = Files.newInputStream(visit.getPath(), new OpenOption[0]);
                try {
                    manifest = new Manifest(is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
            }
            return manifest;
        }
    }

    private static class MultiReleaseMappingReader
    implements Function<PathVisit, Map<String, String>> {
        private static final MultiReleaseMappingReader INSTANCE = new MultiReleaseMappingReader();

        private MultiReleaseMappingReader() {
        }

        @Override
        public Map<String, String> apply(PathVisit visit) {
            if (visit == null) {
                return Collections.emptyMap();
            }
            Path versionsDir = visit.getPath();
            if (!Files.isDirectory(versionsDir, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            final Path root = visit.getPath().getRoot();
            TreeMap versionContentMap = new TreeMap();
            try (Stream<Path> versions = Files.list(versionsDir);){
                versions.forEach(versionDir -> {
                    int version;
                    if (!Files.isDirectory(versionDir, new LinkOption[0])) {
                        return;
                    }
                    try {
                        version = Integer.parseInt(versionDir.getFileName().toString());
                        if (version > JAVA_VERSION) {
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(PathTreeWithManifest.class).debug((Object)("Failed to parse " + versionDir + " entry"), (Throwable)e);
                        return;
                    }
                    versionContentMap.put(version, new Consumer<Map<String, String>>(){

                        @Override
                        public void accept(Map<String, String> map) {
                            try (Stream<Path> versionContent = Files.walk(versionDir, new FileVisitOption[0]);){
                                versionContent.forEach(p -> {
                                    String relativePath = versionDir.relativize((Path)p).toString();
                                    if (!relativePath.isEmpty()) {
                                        map.put(relativePath, root.relativize((Path)p).toString());
                                    }
                                });
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    });
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            HashMap<String, String> multiReleaseMapping = new HashMap<String, String>();
            for (Consumer c : versionContentMap.values()) {
                c.accept(multiReleaseMapping);
            }
            return multiReleaseMapping;
        }
    }
}

