/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.PlatformImports;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class AppModel
implements Serializable {
    public static final String PARENT_FIRST_ARTIFACTS = "parent-first-artifacts";
    public static final String RUNNER_PARENT_FIRST_ARTIFACTS = "runner-parent-first-artifacts";
    public static final String EXCLUDED_ARTIFACTS = "excluded-artifacts";
    public static final String LESSER_PRIORITY_ARTIFACTS = "lesser-priority-artifacts";
    private static final Logger log = Logger.getLogger(AppModel.class);
    private final AppArtifact appArtifact;
    private final List<AppDependency> dependencies;
    private transient List<AppDependency> runtimeDeps;
    private transient List<AppDependency> deploymentDeps;
    private final Set<AppArtifactKey> parentFirstArtifacts;
    private final Set<AppArtifactKey> runnerParentFirstArtifacts;
    private final Set<AppArtifactKey> lesserPriorityArtifacts;
    private final Set<AppArtifactKey> localProjectArtifacts;
    private final PlatformImports platformImports;
    private final Map<String, CapabilityContract> capabilitiesContracts;

    private AppModel(Builder builder) {
        this.appArtifact = builder.appArtifact;
        this.dependencies = builder.filter(builder.dependencies);
        this.parentFirstArtifacts = builder.parentFirstArtifacts;
        this.runnerParentFirstArtifacts = builder.runnerParentFirstArtifacts;
        this.lesserPriorityArtifacts = builder.lesserPriorityArtifacts;
        this.localProjectArtifacts = builder.localProjectArtifacts;
        this.platformImports = builder.platformImports;
        this.capabilitiesContracts = builder.capabilitiesContracts;
        log.debugf("Created AppModel %s", (Object)this);
    }

    public Map<String, String> getPlatformProperties() {
        return this.platformImports == null ? Collections.emptyMap() : this.platformImports.getPlatformProperties();
    }

    public PlatformImports getPlatforms() {
        return this.platformImports;
    }

    public AppArtifact getAppArtifact() {
        return this.appArtifact;
    }

    public List<AppDependency> getUserDependencies() {
        return this.runtimeDeps == null ? (this.runtimeDeps = this.dependencies.stream().filter(d -> d.isRuntimeCp()).collect(Collectors.toList())) : this.runtimeDeps;
    }

    @Deprecated
    public List<AppDependency> getDeploymentDependencies() {
        return this.deploymentDeps == null ? (this.deploymentDeps = this.dependencies.stream().filter(d -> !d.isRuntimeCp()).collect(Collectors.toList())) : this.deploymentDeps;
    }

    public List<AppDependency> getFullDeploymentDeps() {
        return this.dependencies;
    }

    public Set<AppArtifactKey> getParentFirstArtifacts() {
        return this.parentFirstArtifacts;
    }

    public Set<AppArtifactKey> getRunnerParentFirstArtifacts() {
        return this.runnerParentFirstArtifacts;
    }

    public Set<AppArtifactKey> getLesserPriorityArtifacts() {
        return this.lesserPriorityArtifacts;
    }

    public Set<AppArtifactKey> getLocalProjectArtifacts() {
        return this.localProjectArtifacts;
    }

    public Map<String, CapabilityContract> getCapabilityContracts() {
        return this.capabilitiesContracts;
    }

    public String toString() {
        return "AppModel{appArtifact=" + this.appArtifact + ", fullDeploymentDeps=" + this.dependencies + ", parentFirstArtifacts=" + this.parentFirstArtifacts + ", runnerParentFirstArtifacts=" + this.runnerParentFirstArtifacts + "}";
    }

    public static class Builder {
        private AppArtifact appArtifact;
        private final List<AppDependency> dependencies = new ArrayList<AppDependency>();
        private final Set<AppArtifactKey> parentFirstArtifacts = new HashSet<AppArtifactKey>();
        private final Set<AppArtifactKey> runnerParentFirstArtifacts = new HashSet<AppArtifactKey>();
        private final Set<AppArtifactKey> excludedArtifacts = new HashSet<AppArtifactKey>();
        private final Set<AppArtifactKey> lesserPriorityArtifacts = new HashSet<AppArtifactKey>();
        private final Set<AppArtifactKey> localProjectArtifacts = new HashSet<AppArtifactKey>();
        private PlatformImports platformImports;
        private Map<String, CapabilityContract> capabilitiesContracts = Collections.emptyMap();
        private Predicate<AppDependency> depPredicate;

        public Builder setAppArtifact(AppArtifact appArtifact) {
            this.appArtifact = appArtifact;
            return this;
        }

        public Builder setPlatformImports(PlatformImports platformImports) {
            this.platformImports = platformImports;
            return this;
        }

        public Builder setCapabilitiesContracts(Map<String, CapabilityContract> capabilitiesContracts) {
            this.capabilitiesContracts = capabilitiesContracts;
            return this;
        }

        public Builder addDependency(AppDependency dep) {
            this.dependencies.add(dep);
            return this;
        }

        public Builder addDependencies(Collection<AppDependency> deps) {
            this.dependencies.addAll(deps);
            return this;
        }

        @Deprecated
        public Builder addDeploymentDep(AppDependency dep) {
            return this.addDependency(dep);
        }

        @Deprecated
        public Builder addDeploymentDeps(List<AppDependency> deps) {
            return this.addDependencies(deps);
        }

        @Deprecated
        public Builder addFullDeploymentDep(AppDependency dep) {
            return this.addDependency(dep);
        }

        @Deprecated
        public Builder addFullDeploymentDeps(List<AppDependency> deps) {
            return this.addDependencies(deps);
        }

        @Deprecated
        public Builder addRuntimeDep(AppDependency dep) {
            return this.addDependency(dep);
        }

        @Deprecated
        public Builder addRuntimeDeps(List<AppDependency> deps) {
            return this.addDependencies(deps);
        }

        public Builder addParentFirstArtifact(AppArtifactKey deps) {
            this.parentFirstArtifacts.add(deps);
            return this;
        }

        public Builder addParentFirstArtifacts(List<AppArtifactKey> deps) {
            this.parentFirstArtifacts.addAll(deps);
            return this;
        }

        public Builder addRunnerParentFirstArtifact(AppArtifactKey deps) {
            this.runnerParentFirstArtifacts.add(deps);
            return this;
        }

        public Builder addRunnerParentFirstArtifacts(List<AppArtifactKey> deps) {
            this.runnerParentFirstArtifacts.addAll(deps);
            return this;
        }

        public Builder addExcludedArtifact(AppArtifactKey deps) {
            this.excludedArtifacts.add(deps);
            return this;
        }

        public Builder addExcludedArtifacts(List<AppArtifactKey> deps) {
            this.excludedArtifacts.addAll(deps);
            return this;
        }

        public Builder addLesserPriorityArtifact(AppArtifactKey deps) {
            this.lesserPriorityArtifacts.add(deps);
            return this;
        }

        public Builder addLocalProjectArtifact(AppArtifactKey deps) {
            this.localProjectArtifacts.add(deps);
            return this;
        }

        public Builder addLocalProjectArtifacts(Collection<AppArtifactKey> deps) {
            this.localProjectArtifacts.addAll(deps);
            return this;
        }

        public Builder addLesserPriorityArtifacts(List<AppArtifactKey> deps) {
            this.lesserPriorityArtifacts.addAll(deps);
            return this;
        }

        public void handleExtensionProperties(Properties props, String extension) {
            String lesserPriority;
            String excluded;
            String runnerParentFirst;
            String parentFirst = props.getProperty(AppModel.PARENT_FIRST_ARTIFACTS);
            if (parentFirst != null) {
                String[] artifacts;
                for (String artifact : artifacts = parentFirst.split(",")) {
                    this.parentFirstArtifacts.add(new AppArtifactKey(artifact.split(":")));
                }
            }
            if ((runnerParentFirst = props.getProperty(AppModel.RUNNER_PARENT_FIRST_ARTIFACTS)) != null) {
                String[] artifacts;
                for (String artifact : artifacts = runnerParentFirst.split(",")) {
                    this.runnerParentFirstArtifacts.add(new AppArtifactKey(artifact.split(":")));
                }
            }
            if ((excluded = props.getProperty(AppModel.EXCLUDED_ARTIFACTS)) != null) {
                String[] artifacts;
                for (String artifact : artifacts = excluded.split(",")) {
                    this.excludedArtifacts.add(new AppArtifactKey(artifact.split(":")));
                    log.debugf("Extension %s is excluding %s", (Object)extension, (Object)artifact);
                }
            }
            if ((lesserPriority = props.getProperty(AppModel.LESSER_PRIORITY_ARTIFACTS)) != null) {
                String[] artifacts;
                for (String artifact : artifacts = lesserPriority.split(",")) {
                    this.lesserPriorityArtifacts.add(new AppArtifactKey(artifact.split(":")));
                    log.debugf("Extension %s is making %s a lesser priority artifact", (Object)extension, (Object)artifact);
                }
            }
        }

        private Predicate<AppDependency> dependencyPredicate() {
            if (this.depPredicate == null) {
                this.depPredicate = s -> {
                    if (s.getArtifact().getGroupId().equals("io.quarkus") && s.getArtifact().getArtifactId().equals("quarkus-ide-launcher")) {
                        return false;
                    }
                    return !this.excludedArtifacts.contains(s.getArtifact().getKey());
                };
            }
            return this.depPredicate;
        }

        private List<AppDependency> filter(List<AppDependency> deps) {
            return deps.stream().filter(this.dependencyPredicate()).collect(Collectors.toList());
        }

        public AppModel build() {
            return new AppModel(this);
        }
    }
}

