/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model.gradle.impl;

import io.quarkus.bootstrap.model.gradle.Dependency;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DependencyImpl
implements Dependency,
Serializable {
    private final String name;
    private final String groupId;
    private final String version;
    private final String classifier;
    private final Set<File> paths = new HashSet<File>();
    private final String scope;
    private final String type;
    private int flags;

    public DependencyImpl(String name, String groupId, String version, File path, String scope, String type, String classifier, int ... flags) {
        this(name, groupId, version, scope, type, classifier, flags);
        this.paths.add(path);
    }

    public DependencyImpl(String name, String groupId, String version, String scope, String type, String classifier, int ... flags) {
        this.name = name;
        this.groupId = groupId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        int allFlags = 0;
        for (int flag : flags) {
            allFlags |= flag;
        }
        this.flags = allFlags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public Set<File> getPaths() {
        return this.paths;
    }

    public void addPath(File path) {
        this.paths.add(path);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) > 0;
    }

    public String toString() {
        return "DependencyImpl{name='" + this.name + "', groupId='" + this.groupId + "', version='" + this.version + "', type='" + this.type + "', path=" + this.paths + ", classifier= " + this.classifier + ", scope='" + this.scope + "'}";
    }

    public int hashCode() {
        return Objects.hash(this.classifier, this.flags, this.groupId, this.name, this.paths, this.scope, this.type, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyImpl other = (DependencyImpl)obj;
        return Objects.equals(this.classifier, other.classifier) && this.flags == other.flags && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.name, other.name) && Objects.equals(this.paths, other.paths) && Objects.equals(this.scope, other.scope) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version);
    }
}

