/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.EmptyPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathTree;
import java.io.File;
import java.util.Collection;

public interface WorkspaceModule {
    public WorkspaceModuleId getId();

    public File getModuleDir();

    public File getBuildDir();

    public Collection<String> getSourceClassifiers();

    public boolean hasSources(String var1);

    public ArtifactSources getSources(String var1);

    default public boolean hasMainSources() {
        return this.hasSources("");
    }

    default public boolean hasTestSources() {
        return this.hasSources("tests");
    }

    default public ArtifactSources getMainSources() {
        return this.getSources("");
    }

    default public ArtifactSources getTestSources() {
        return this.getSources("tests");
    }

    public PathCollection getBuildFiles();

    default public PathTree getContentTree(String classifier) {
        ArtifactSources artifactSources = this.getSources(classifier);
        return artifactSources == null || !artifactSources.isOutputAvailable() ? EmptyPathTree.getInstance() : artifactSources.getOutputTree();
    }

    public Collection<Dependency> getDirectDependencyConstraints();

    public Collection<Dependency> getDirectDependencies();
}

