/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultWorkspaceModule
implements WorkspaceModule,
Serializable {
    private WorkspaceModuleId id;
    private File moduleDir;
    private File buildDir;
    private PathCollection buildFiles;
    private Map<String, ArtifactSources> sourcesSets = new HashMap<String, ArtifactSources>();
    private List<Dependency> directDepConstraints;
    private List<Dependency> directDeps;

    public static Builder builder() {
        return new DefaultWorkspaceModule().new Builder();
    }

    private DefaultWorkspaceModule() {
    }

    private DefaultWorkspaceModule(WorkspaceModule module) {
        this.id = module.getId();
        this.moduleDir = module.getModuleDir();
        this.buildDir = module.getBuildDir();
        this.buildFiles = module.getBuildFiles().isEmpty() ? null : module.getBuildFiles();
        for (String classifier : module.getSourceClassifiers()) {
            this.sourcesSets.put(classifier, module.getSources(classifier));
        }
        this.directDepConstraints = module.getDirectDependencyConstraints().isEmpty() ? null : new ArrayList<Dependency>(module.getDirectDependencyConstraints());
        this.directDeps = module.getDirectDependencies().isEmpty() ? null : new ArrayList<Dependency>(module.getDirectDependencies());
    }

    public DefaultWorkspaceModule(WorkspaceModuleId id, File moduleDir, File buildDir) {
        this.id = id;
        this.moduleDir = moduleDir;
        this.buildDir = buildDir;
    }

    @Override
    public WorkspaceModuleId getId() {
        return this.id;
    }

    @Override
    public File getModuleDir() {
        return this.moduleDir;
    }

    @Override
    public File getBuildDir() {
        return this.buildDir;
    }

    public void addArtifactSources(ArtifactSources src) {
        this.sourcesSets.put(src.getClassifier(), src);
    }

    @Override
    public boolean hasSources(String classifier) {
        return this.sourcesSets.containsKey(classifier);
    }

    @Override
    public ArtifactSources getSources(String name) {
        return this.sourcesSets.get(name);
    }

    @Override
    public Collection<String> getSourceClassifiers() {
        return this.sourcesSets.keySet();
    }

    public void setBuildFiles(PathCollection buildFiles) {
        this.buildFiles = buildFiles;
    }

    @Override
    public PathCollection getBuildFiles() {
        return this.buildFiles == null ? PathList.empty() : this.buildFiles;
    }

    @Override
    public Collection<Dependency> getDirectDependencyConstraints() {
        return this.directDepConstraints == null ? Collections.emptyList() : this.directDepConstraints;
    }

    public void setDirectDependencyConstraints(List<Dependency> directDepConstraints) {
        this.directDepConstraints = directDepConstraints;
    }

    @Override
    public Collection<Dependency> getDirectDependencies() {
        return this.directDeps == null ? Collections.emptyList() : this.directDeps;
    }

    public void setDirectDependencies(List<Dependency> directDeps) {
        this.directDeps = directDeps;
    }

    public void addDirectDependency(Dependency directDep) {
        if (this.directDeps == null || this.directDeps.isEmpty()) {
            this.directDeps = new ArrayList<Dependency>();
        }
        this.directDeps.add(directDep);
    }

    @Override
    public WorkspaceModule.Mutable mutable() {
        return new DefaultWorkspaceModule(this).new Builder();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" ").append(this.moduleDir);
        this.sourcesSets.values().forEach(a -> buf.append(" ").append(a));
        return buf.toString();
    }

    public class Builder
    implements WorkspaceModule.Mutable,
    Serializable {
        private Builder() {
        }

        @Override
        public Builder setModuleId(WorkspaceModuleId moduleId) {
            DefaultWorkspaceModule.this.id = moduleId;
            return this;
        }

        @Override
        public Builder setModuleDir(Path moduleDir) {
            DefaultWorkspaceModule.this.moduleDir = moduleDir.toFile();
            return this;
        }

        @Override
        public Builder setBuildDir(Path buildDir) {
            DefaultWorkspaceModule.this.buildDir = buildDir.toFile();
            return this;
        }

        @Override
        public Builder setBuildFile(Path buildFile) {
            DefaultWorkspaceModule.this.buildFiles = PathList.of(buildFile);
            return this;
        }

        @Override
        public Builder addDependencyConstraint(Dependency constraint) {
            if (DefaultWorkspaceModule.this.directDepConstraints == null) {
                DefaultWorkspaceModule.this.directDepConstraints = new ArrayList<Dependency>();
            }
            DefaultWorkspaceModule.this.directDepConstraints.add(constraint);
            return this;
        }

        @Override
        public Builder setDependencyConstraints(List<Dependency> constraints) {
            DefaultWorkspaceModule.this.directDepConstraints = constraints;
            return this;
        }

        @Override
        public Builder addDependency(Dependency dep) {
            if (DefaultWorkspaceModule.this.directDeps == null) {
                DefaultWorkspaceModule.this.directDeps = new ArrayList<Dependency>();
            }
            DefaultWorkspaceModule.this.directDeps.add(dep);
            return this;
        }

        @Override
        public Builder setDependencies(List<Dependency> deps) {
            DefaultWorkspaceModule.this.directDeps = deps;
            return this;
        }

        @Override
        public Builder addArtifactSources(ArtifactSources sources) {
            DefaultWorkspaceModule.this.sourcesSets.put(sources.getClassifier(), sources);
            return this;
        }

        @Override
        public boolean hasMainSources() {
            return DefaultWorkspaceModule.this.sourcesSets.containsKey("");
        }

        @Override
        public boolean hasTestSources() {
            return DefaultWorkspaceModule.this.sourcesSets.containsKey("tests");
        }

        @Override
        public WorkspaceModule build() {
            DefaultWorkspaceModule module = DefaultWorkspaceModule.this;
            if (module.id == null) {
                throw new IllegalArgumentException("Module id is missing");
            }
            module.directDepConstraints = module.directDepConstraints == null ? Collections.emptyList() : Collections.unmodifiableList(module.directDepConstraints);
            module.directDeps = module.directDeps == null ? Collections.emptyList() : Collections.unmodifiableList(module.directDeps);
            module.sourcesSets = Collections.unmodifiableMap(module.sourcesSets);
            return module;
        }

        @Override
        public WorkspaceModuleId getId() {
            return DefaultWorkspaceModule.this.getId();
        }

        @Override
        public File getModuleDir() {
            return DefaultWorkspaceModule.this.getModuleDir();
        }

        @Override
        public File getBuildDir() {
            return DefaultWorkspaceModule.this.getBuildDir();
        }

        @Override
        public Collection<String> getSourceClassifiers() {
            return DefaultWorkspaceModule.this.getSourceClassifiers();
        }

        @Override
        public boolean hasSources(String classifier) {
            return DefaultWorkspaceModule.this.hasSources(classifier);
        }

        @Override
        public ArtifactSources getSources(String classifier) {
            return DefaultWorkspaceModule.this.getSources(classifier);
        }

        @Override
        public PathCollection getBuildFiles() {
            return DefaultWorkspaceModule.this.getBuildFiles();
        }

        @Override
        public Collection<Dependency> getDirectDependencyConstraints() {
            return DefaultWorkspaceModule.this.getDirectDependencyConstraints();
        }

        @Override
        public Collection<Dependency> getDirectDependencies() {
            return DefaultWorkspaceModule.this.getDirectDependencies();
        }
    }
}

