/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.Serializable;
import java.util.Objects;

public class GACTV
implements ArtifactCoords,
Serializable {
    private static final long serialVersionUID = -8362130311897578173L;
    private final String groupId;
    private final String artifactId;
    private final String classifier;
    private final String type;
    private final String version;
    private transient ArtifactKey key;

    public static GACTV fromString(String str) {
        return new GACTV(GACTV.split(str, new String[5]));
    }

    public static ArtifactCoords pom(String groupId, String artifactId, String version) {
        return new GACTV(groupId, artifactId, null, "pom", version);
    }

    protected static String[] split(String str, String[] parts) {
        int versionSep = str.lastIndexOf(58);
        if (versionSep <= 0 || versionSep == str.length() - 1) {
            throw new IllegalArgumentException("One of type, version or separating them ':' is missing from '" + str + "'");
        }
        parts[4] = str.substring(versionSep + 1);
        return GACT.split(str, parts, versionSep);
    }

    protected GACTV(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts[2];
        this.type = parts[3] == null ? "jar" : parts[3];
        this.version = parts[4];
    }

    public GACTV(ArtifactKey key, String version) {
        this.key = key;
        this.groupId = key.getGroupId();
        this.artifactId = key.getArtifactId();
        this.classifier = key.getClassifier();
        this.type = key.getType();
        this.version = version;
    }

    public GACTV(String groupId, String artifactId, String version) {
        this(groupId, artifactId, "", "jar", version);
    }

    public GACTV(String groupId, String artifactId, String type, String version) {
        this(groupId, artifactId, "", type, version);
    }

    public GACTV(String groupId, String artifactId, String classifier, String type, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type == null ? "jar" : type;
        this.version = version;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ArtifactKey getKey() {
        return this.key == null ? (this.key = new GACT(this.groupId, this.artifactId, this.classifier, this.type)) : this.key;
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.classifier, this.groupId, this.type, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactCoords)) {
            return false;
        }
        ArtifactCoords other = (ArtifactCoords)obj;
        return Objects.equals(this.artifactId, other.getArtifactId()) && Objects.equals(this.groupId, other.getGroupId()) && Objects.equals(this.version, other.getVersion()) && Objects.equals(this.type, other.getType()) && Objects.equals(this.classifier, other.getClassifier());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.append(buf);
        return buf.toString();
    }

    protected StringBuilder append(StringBuilder buf) {
        buf.append(this.groupId).append(':').append(this.artifactId).append(':');
        if (this.classifier != null && !this.classifier.isEmpty()) {
            buf.append(this.classifier);
        }
        return buf.append(':').append(this.type).append(':').append(this.version);
    }
}

