/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.ManifestAttributes;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class FilteredPathTree
implements PathTree {
    private final PathTree original;
    protected final PathFilter filter;

    public FilteredPathTree(PathTree tree, PathFilter filter) {
        this.original = Objects.requireNonNull(tree, "tree is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    @Override
    public Collection<Path> getRoots() {
        return this.original.getRoots();
    }

    @Override
    public ManifestAttributes getManifestAttributes() {
        return this.original.getManifestAttributes();
    }

    @Override
    public void walk(PathVisitor visitor) {
        this.original.walk(visit -> {
            if (visit != null && this.filter.isVisible(visit.getRelativePath("/"))) {
                visitor.visitPath(visit);
            }
        });
    }

    @Override
    public <T> T apply(String relativePath, Function<PathVisit, T> func) {
        if (!PathFilter.isVisible(this.filter, relativePath)) {
            return func.apply(null);
        }
        return this.original.apply(relativePath, func);
    }

    @Override
    public void accept(String relativePath, Consumer<PathVisit> consumer) {
        if (!PathFilter.isVisible(this.filter, relativePath)) {
            consumer.accept(null);
        } else {
            this.original.accept(relativePath, consumer);
        }
    }

    @Override
    public void acceptAll(String relativePath, Consumer<PathVisit> consumer) {
        if (!PathFilter.isVisible(this.filter, relativePath)) {
            consumer.accept(null);
        } else {
            this.original.acceptAll(relativePath, consumer);
        }
    }

    @Override
    public boolean contains(String relativePath) {
        return PathFilter.isVisible(this.filter, relativePath) && this.original.contains(relativePath);
    }

    @Override
    public OpenPathTree open() {
        return new OpenFilteredPathTree(this.original.open(), this.filter);
    }

    private static class OpenFilteredPathTree
    extends FilteredPathTree
    implements OpenPathTree {
        private final OpenPathTree original;

        private OpenFilteredPathTree(OpenPathTree original, PathFilter filter) {
            super(original, filter);
            this.original = original;
        }

        @Override
        public PathTree getOriginalTree() {
            return this.original.getOriginalTree();
        }

        @Override
        public boolean isOpen() {
            return this.original.isOpen();
        }

        @Override
        public Path getPath(String relativePath) {
            if (!PathFilter.isVisible(this.filter, relativePath)) {
                return null;
            }
            return this.original.getPath(relativePath);
        }

        @Override
        public void close() throws IOException {
            this.original.close();
        }
    }
}

